/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.sink;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.sink.HBaseMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseConfigurationUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Connection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Mutation;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.util.MetricStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction,
BufferedMutator.ExceptionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseSinkFunction.class);
    private final String hTableName;
    private final byte[] serializedConfig;
    private final long bufferFlushMaxSizeInBytes;
    private final long bufferFlushMaxMutations;
    private final long bufferFlushIntervalMillis;
    private final HBaseMutationConverter<T> mutationConverter;
    private final String inlongMetric;
    private final String inlongAudit;
    private final AtomicReference<Throwable> failureThrowable = new AtomicReference();
    private transient ListState<MetricState> metricStateListState;
    private transient MetricState metricState;
    private SinkMetricData sinkMetricData;
    private transient Connection connection;
    private transient BufferedMutator mutator;
    private transient ScheduledExecutorService executor;
    private transient ScheduledFuture scheduledFuture;
    private transient AtomicLong numPendingRequests;
    private transient RuntimeContext runtimeContext;
    private volatile transient boolean closed = false;
    private Long dataSize = 0L;
    private Long rowSize = 0L;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;

    public HBaseSinkFunction(String hTableName, org.apache.hadoop.conf.Configuration conf, HBaseMutationConverter<T> mutationConverter, long bufferFlushMaxSizeInBytes, long bufferFlushMaxMutations, long bufferFlushIntervalMillis, String inlongMetric, String inlongAudit, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        this.hTableName = hTableName;
        this.serializedConfig = HBaseConfigurationUtil.serializeConfiguration(conf);
        this.mutationConverter = mutationConverter;
        this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
        this.bufferFlushMaxMutations = bufferFlushMaxMutations;
        this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public void open(Configuration parameters) throws Exception {
        LOGGER.info("Start hbase sink function open ...");
        org.apache.hadoop.conf.Configuration config = this.prepareRuntimeConfiguration();
        try {
            this.runtimeContext = this.getRuntimeContext();
            MetricOption metricOption = MetricOption.builder().withInlongLabels(this.inlongMetric).withInlongAudit(this.inlongAudit).withInitRecords(this.metricState != null ? this.metricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(this.metricState != null ? this.metricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(this.metricState != null ? this.metricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(this.metricState != null ? this.metricState.getMetricValue("dirtyBytesOut") : 0L).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
            if (metricOption != null) {
                this.sinkMetricData = new SinkMetricData(metricOption, this.runtimeContext.getMetricGroup());
            }
            if (this.dirtySink != null) {
                this.dirtySink.open(parameters);
            }
            this.mutationConverter.open();
            this.numPendingRequests = new AtomicLong(0L);
            if (null == this.connection) {
                this.connection = ConnectionFactory.createConnection(config);
            }
            BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf(this.hTableName)).listener(this);
            if (this.bufferFlushMaxSizeInBytes > 0L) {
                params.writeBufferSize(this.bufferFlushMaxSizeInBytes);
            }
            this.mutator = this.connection.getBufferedMutator(params);
            if (this.bufferFlushIntervalMillis > 0L && this.bufferFlushMaxMutations != 1L) {
                this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("hbase-upsert-sink-flusher"));
                this.scheduledFuture = this.executor.scheduleWithFixedDelay(() -> {
                    if (this.closed) {
                        return;
                    }
                    this.reportMetricAfterFlush();
                }, this.bufferFlushIntervalMillis, this.bufferFlushIntervalMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (TableNotFoundException tnfe) {
            LOGGER.error("The table " + this.hTableName + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.hTableName + "' not found.", tnfe);
        }
        catch (IOException ioe) {
            LOGGER.error("Exception while creating connection to HBase.", (Throwable)ioe);
            throw new RuntimeException("Cannot create connection to HBase.", ioe);
        }
        LOGGER.info("End hbase sink function open.");
    }

    private org.apache.hadoop.conf.Configuration prepareRuntimeConfiguration() throws IOException {
        org.apache.hadoop.conf.Configuration runtimeConfig = HBaseConfigurationUtil.deserializeConfiguration(this.serializedConfig, HBaseConfigurationUtil.getHBaseConfiguration());
        if (StringUtils.isNullOrWhitespaceOnly((String)runtimeConfig.get("hbase.zookeeper.quorum"))) {
            LOGGER.error("Can not connect to HBase without {} configuration", (Object)"hbase.zookeeper.quorum");
            throw new IOException("Check HBase configuration failed, lost: 'hbase.zookeeper.quorum'!");
        }
        return runtimeConfig;
    }

    private void checkErrorAndRethrow() {
        Throwable cause = this.failureThrowable.get();
        if (cause != null) {
            LOGGER.error("An error occurred in HBaseSink.", cause);
            throw new RuntimeException(cause);
        }
    }

    public void invoke(T value, SinkFunction.Context context) {
        this.checkErrorAndRethrow();
        RowData rowData = (RowData)value;
        if (RowKind.UPDATE_BEFORE != rowData.getRowKind()) {
            Mutation mutation;
            block10: {
                mutation = null;
                try {
                    mutation = (Mutation)Preconditions.checkNotNull((Object)this.mutationConverter.convertToMutation(value));
                    Long l = this.rowSize;
                    Long l2 = this.rowSize = Long.valueOf(this.rowSize + 1L);
                    this.dataSize = this.dataSize + (long)value.toString().getBytes(StandardCharsets.UTF_8).length;
                }
                catch (Exception e) {
                    LOGGER.error("Convert to mutation error", (Throwable)e);
                    if (!this.dirtyOptions.ignoreDirty()) {
                        throw new RuntimeException(e);
                    }
                    this.sinkMetricData.invokeDirty(1L, value.toString().getBytes(StandardCharsets.UTF_8).length);
                    if (this.dirtySink == null) break block10;
                    DirtyData.Builder<RowData> builder = DirtyData.builder();
                    try {
                        builder.setData(rowData).setDirtyType(DirtyType.UNDEFINED).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setDirtyMessage(e.getMessage()).setIdentifier(this.dirtyOptions.getIdentifier());
                        this.dirtySink.invoke(builder.build());
                    }
                    catch (Exception ex) {
                        if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                            throw new RuntimeException(ex);
                        }
                        LOGGER.warn("Dirty sink failed", (Throwable)ex);
                    }
                }
            }
            try {
                this.mutator.mutate(mutation);
            }
            catch (Exception e) {
                this.failureThrowable.compareAndSet(null, e);
            }
        }
        if (this.bufferFlushMaxMutations > 0L && this.numPendingRequests.incrementAndGet() >= this.bufferFlushMaxMutations) {
            this.reportMetricAfterFlush();
        }
    }

    private void reportMetricAfterFlush() {
        try {
            this.flush();
            if (this.sinkMetricData != null) {
                this.sinkMetricData.invoke(this.rowSize, this.dataSize);
            }
            this.resetStateAfterFlush();
        }
        catch (Exception e) {
            this.failureThrowable.compareAndSet(null, e);
        }
    }

    private void resetStateAfterFlush() {
        this.dataSize = 0L;
        this.rowSize = 0L;
    }

    private void flush() throws IOException {
        this.mutator.flush();
        this.numPendingRequests.set(0L);
        this.checkErrorAndRethrow();
    }

    public void close() throws Exception {
        this.closed = true;
        if (this.mutator != null) {
            try {
                this.mutator.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception occurs while closing HBase BufferedMutator.", (Throwable)e);
            }
            this.mutator = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOGGER.warn("Exception occurs while closing HBase Connection.", (Throwable)e);
            }
            this.connection = null;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        while (this.numPendingRequests.get() != 0L) {
            this.reportMetricAfterFlush();
        }
        if (this.sinkMetricData != null && this.metricStateListState != null) {
            MetricStateUtils.snapshotMetricStateForSinkMetricData(this.metricStateListState, this.sinkMetricData, this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
        if (this.inlongMetric != null) {
            this.metricStateListState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("inlong-metric-states", TypeInformation.of((TypeHint)new TypeHint<MetricState>(){})));
        }
        if (context.isRestored()) {
            this.metricState = MetricStateUtils.restoreMetricState(this.metricStateListState, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getNumberOfParallelSubtasks());
        }
    }

    @Override
    public void onException(RetriesExhaustedWithDetailsException exception, BufferedMutator mutator) throws RetriesExhaustedWithDetailsException {
        this.failureThrowable.compareAndSet(null, exception);
    }
}

