/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.sink;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.sink.RowDataToMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.hadoop.conf.Configuration;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.hbase.sink.HBaseSinkFunction;

@Internal
public class HBaseDynamicTableSink
implements DynamicTableSink {
    private final String tableName;
    private final HBaseTableSchema hbaseTableSchema;
    private final Configuration hbaseConf;
    private final HBaseWriteOptions writeOptions;
    private final String nullStringLiteral;
    private final String inlongMetric;
    private final String inlongAudit;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;

    public HBaseDynamicTableSink(String tableName, HBaseTableSchema hbaseTableSchema, Configuration hbaseConf, HBaseWriteOptions writeOptions, String nullStringLiteral, String inlongMetric, String inlongAudit, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        this.tableName = tableName;
        this.hbaseTableSchema = hbaseTableSchema;
        this.hbaseConf = hbaseConf;
        this.writeOptions = writeOptions;
        this.nullStringLiteral = nullStringLiteral;
        this.inlongMetric = inlongMetric;
        this.inlongAudit = inlongAudit;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        HBaseSinkFunction<RowData> sinkFunction = new HBaseSinkFunction<RowData>(this.tableName, this.hbaseConf, new RowDataToMutationConverter(this.hbaseTableSchema, this.nullStringLiteral), this.writeOptions.getBufferFlushMaxSizeInBytes(), this.writeOptions.getBufferFlushMaxRows(), this.writeOptions.getBufferFlushIntervalMillis(), this.inlongMetric, this.inlongAudit, this.dirtyOptions, this.dirtySink);
        return SinkFunctionProvider.of(sinkFunction, (Integer)this.writeOptions.getParallelism());
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return ChangelogMode.all();
    }

    public DynamicTableSink copy() {
        return new HBaseDynamicTableSink(this.tableName, this.hbaseTableSchema, this.hbaseConf, this.writeOptions, this.nullStringLiteral, this.inlongMetric, this.inlongAudit, this.dirtyOptions, this.dirtySink);
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseTableSchema;
    }

    @VisibleForTesting
    public HBaseWriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.hbaseConf;
    }

    @VisibleForTesting
    public String getTableName() {
        return this.tableName;
    }
}

