/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.sub;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.hbase.shaded.com.google.common.collect.Maps;
import org.apache.flink.hbase.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.enums.ReadPhase;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.SourceMetricData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.phase.ReadPhaseMetricData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.metric.sub.SourceSubMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTableMetricData
extends SourceMetricData
implements SourceSubMetricData {
    public static final Logger LOGGER = LoggerFactory.getLogger(SourceTableMetricData.class);
    private final Map<ReadPhase, ReadPhaseMetricData> readPhaseMetricDataMap = Maps.newHashMap();
    private final Map<String, SourceMetricData> subSourceMetricMap = Maps.newHashMap();
    private final List<String> tableMetricLabelList;

    public SourceTableMetricData(MetricOption option, MetricGroup metricGroup, List<String> tableMetricLabelList) {
        super(option, metricGroup);
        this.tableMetricLabelList = tableMetricLabelList;
    }

    public void registerSubMetricsGroup(MetricState metricState) {
        if (metricState == null) {
            return;
        }
        Stream.of(ReadPhase.values()).forEach(readPhase -> {
            Long readPhaseMetricValue = metricState.getMetricValue(readPhase.getPhase());
            if (readPhaseMetricValue > 0L) {
                this.outputReadPhaseMetrics(metricState, (ReadPhase)((Object)readPhase));
            }
        });
        if (metricState.getSubMetricStateMap() == null) {
            return;
        }
        Map<String, MetricState> subMetricStateMap = metricState.getSubMetricStateMap();
        for (Map.Entry<String, MetricState> subMetricStateEntry : subMetricStateMap.entrySet()) {
            String[] schemaInfoArray = subMetricStateEntry.getKey().split("\\.");
            MetricState subMetricState = subMetricStateEntry.getValue();
            SourceMetricData subSourceMetricData = this.buildSubSourceMetricData(schemaInfoArray, subMetricState, this);
            this.subSourceMetricMap.put(subMetricStateEntry.getKey(), subSourceMetricData);
        }
        LOGGER.info("register subMetricsGroup from metricState,sub metric map size:{}", (Object)this.subSourceMetricMap.size());
    }

    private SourceMetricData buildSubSourceMetricData(String[] schemaInfoArray, SourceMetricData sourceMetricData) {
        return this.buildSubSourceMetricData(schemaInfoArray, null, sourceMetricData);
    }

    private SourceMetricData buildSubSourceMetricData(String[] schemaInfoArray, MetricState subMetricState, SourceMetricData sourceMetricData) {
        if (sourceMetricData == null || schemaInfoArray == null) {
            return null;
        }
        Map<String, String> labels = sourceMetricData.getLabels();
        String metricGroupLabels = labels.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        StringBuilder labelBuilder = new StringBuilder(metricGroupLabels);
        for (int i = 0; i < this.tableMetricLabelList.size(); ++i) {
            labelBuilder.append("&").append(this.tableMetricLabelList.get(i)).append("=").append(schemaInfoArray[i]);
        }
        MetricOption metricOption = MetricOption.builder().withInitRecords(subMetricState != null ? subMetricState.getMetricValue("numRecordsIn") : 0L).withInitBytes(subMetricState != null ? subMetricState.getMetricValue("numBytesIn") : 0L).withInlongLabels(labelBuilder.toString()).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        return new SourceTableMetricData(metricOption, sourceMetricData.getMetricGroup(), this.tableMetricLabelList);
    }

    public void outputMetricsWithEstimate(String database, String table, boolean isSnapshotRecord, Object data) {
        if (StringUtils.isBlank(database) || StringUtils.isBlank(table)) {
            this.outputMetricsWithEstimate(data);
            return;
        }
        this.outputMetricsWithEstimate(new String[]{database, table}, isSnapshotRecord, data);
    }

    public void outputMetricsWithEstimate(String database, String schema, String table, boolean isSnapshotRecord, Object data) {
        if (StringUtils.isBlank(database) || StringUtils.isBlank(schema) || StringUtils.isBlank(table)) {
            this.outputMetricsWithEstimate(data);
            return;
        }
        this.outputMetricsWithEstimate(new String[]{database, schema, table}, isSnapshotRecord, data);
    }

    public void outputMetricsWithEstimate(String[] recordSchemaInfoArray, boolean isSnapshotRecord, Object data) {
        SourceMetricData subSourceMetricData;
        if (recordSchemaInfoArray == null) {
            this.outputMetricsWithEstimate(data);
            return;
        }
        String identify = String.join((CharSequence)".", recordSchemaInfoArray);
        if (this.subSourceMetricMap.containsKey(identify)) {
            subSourceMetricData = this.subSourceMetricMap.get(identify);
        } else {
            subSourceMetricData = this.buildSubSourceMetricData(recordSchemaInfoArray, this);
            this.subSourceMetricMap.put(identify, subSourceMetricData);
        }
        long rowCountSize = 1L;
        long rowDataSize = data.toString().getBytes(StandardCharsets.UTF_8).length;
        this.outputMetrics(rowCountSize, rowDataSize);
        subSourceMetricData.outputMetrics(rowCountSize, rowDataSize);
        this.outputReadPhaseMetrics(isSnapshotRecord ? ReadPhase.SNAPSHOT_PHASE : ReadPhase.INCREASE_PHASE);
    }

    public void outputReadPhaseMetrics(ReadPhase readPhase) {
        this.outputReadPhaseMetrics(null, readPhase);
    }

    public void outputReadPhaseMetrics(MetricState metricState, ReadPhase readPhase) {
        ReadPhaseMetricData readPhaseMetricData = this.readPhaseMetricDataMap.get((Object)readPhase);
        if (readPhaseMetricData == null) {
            String metricGroupLabels = this.getLabels().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
            MetricOption metricOption = MetricOption.builder().withInitReadPhase(metricState != null ? metricState.getMetricValue(readPhase.getPhase()) : 0L).withInlongLabels(metricGroupLabels + "&" + "readPhase" + "=" + readPhase.getCode()).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
            readPhaseMetricData = new ReadPhaseMetricData(metricOption, this.getMetricGroup());
            this.readPhaseMetricDataMap.put(readPhase, readPhaseMetricData);
        }
        readPhaseMetricData.outputMetrics();
    }

    @Override
    public Map<ReadPhase, ReadPhaseMetricData> getReadPhaseMetricMap() {
        return this.readPhaseMetricDataMap;
    }

    @Override
    public Map<String, SourceMetricData> getSubSourceMetricMap() {
        return this.subSourceMetricMap;
    }

    @Override
    public String toString() {
        return "SourceTableMetricData{numRecordsIn=" + this.getNumRecordsIn().getCount() + ", numBytesIn=" + this.getNumBytesIn().getCount() + ", readPhaseMetricDataMap=" + this.readPhaseMetricDataMap + ", subSourceMetricMap=" + this.subSourceMetricMap + '}';
    }
}

