/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format.AbstractDynamicSchemaFormat;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format.CanalJsonDynamicSchemaFormat;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format.DebeziumJsonDynamicSchemaFormat;

public class DynamicSchemaFormatFactory {
    public static Map<String, Function<Map<String, String>, AbstractDynamicSchemaFormat>> SUPPORT_FORMATS = ImmutableMap.of((Object)"canal-json", props -> new CanalJsonDynamicSchemaFormat((Map<String, String>)props), (Object)"debezium-json", props -> new DebeziumJsonDynamicSchemaFormat((Map<String, String>)props));

    public static AbstractDynamicSchemaFormat getFormat(String identifier) {
        return DynamicSchemaFormatFactory.getFormat(identifier, new HashMap<String, String>());
    }

    public static AbstractDynamicSchemaFormat getFormat(String identifier, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)identifier, (String)"The identifier is null");
        return Optional.ofNullable(SUPPORT_FORMATS.get(identifier)).orElseThrow(() -> new UnsupportedOperationException("Unsupport dynamic schema format for:" + identifier)).apply(properties);
    }
}

