/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirtySinkHelper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirtySinkHelper.class);
    private DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<T> dirtySink;

    public DirtySinkHelper(DirtyOptions dirtyOptions, @Nullable DirtySink<T> dirtySink) {
        this.dirtyOptions = (DirtyOptions)Preconditions.checkNotNull((Object)dirtyOptions, (String)"dirtyOptions is null");
        this.dirtySink = dirtySink;
    }

    public void open(Configuration configuration) {
        if (this.dirtySink != null) {
            try {
                this.dirtySink.open(configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void invoke(T dirtyData, DirtyType dirtyType, Throwable e) {
        if (!this.dirtyOptions.ignoreDirty()) {
            RuntimeException ex = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            throw ex;
        }
        if (this.dirtySink != null) {
            DirtyData.Builder<T> builder = DirtyData.builder();
            try {
                builder.setData(dirtyData).setDirtyType(dirtyType).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setDirtyMessage(e.getMessage()).setIdentifier(this.dirtyOptions.getIdentifier());
                this.dirtySink.invoke(builder.build());
            }
            catch (Exception ex) {
                if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                    throw new RuntimeException(ex);
                }
                LOGGER.warn("Dirty sink failed", (Throwable)ex);
            }
        }
    }

    public void invokeMultiple(T dirtyData, DirtyType dirtyType, Throwable e, String sinkMultipleFormat) {
        JsonDynamicSchemaFormat jsonDynamicSchemaFormat = (JsonDynamicSchemaFormat)DynamicSchemaFormatFactory.getFormat(sinkMultipleFormat);
        if (!this.dirtyOptions.ignoreDirty()) {
            RuntimeException ex = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            throw ex;
        }
        if (this.dirtySink != null) {
            JsonNode rootNode;
            DirtyData.Builder<T> builder = DirtyData.builder();
            try {
                rootNode = jsonDynamicSchemaFormat.deserialize(((RowData)dirtyData).getBinary(0));
            }
            catch (Exception ex) {
                this.invoke(dirtyData, DirtyType.DESERIALIZE_ERROR, e);
                return;
            }
            try {
                builder.setData(dirtyData).setDirtyType(dirtyType).setLabels(jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getLabels())).setLogTag(jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getLogTag())).setDirtyMessage(e.getMessage()).setIdentifier(jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getIdentifier()));
                this.dirtySink.invoke(builder.build());
            }
            catch (Exception ex) {
                if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                    throw new RuntimeException(ex);
                }
                LOGGER.warn("Dirty sink failed", (Throwable)ex);
            }
        }
    }

    public void setDirtyOptions(DirtyOptions dirtyOptions) {
        this.dirtyOptions = dirtyOptions;
    }

    public DirtyOptions getDirtyOptions() {
        return this.dirtyOptions;
    }

    @Nullable
    public DirtySink<T> getDirtySink() {
        return this.dirtySink;
    }
}

