/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.hbase.shaded.org.apache.inlong.sort.base.util.PatternReplaceUtils;

public class DirtyData<T> {
    private static final String DIRTY_TYPE_KEY = "DIRTY_TYPE";
    private static final String DIRTY_MESSAGE_KEY = "DIRTY_MESSAGE";
    private static final String SYSTEM_TIME_KEY = "SYSTEM_TIME";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final String identifier;
    private final String labels;
    private final String logTag;
    private final DirtyType dirtyType;
    private final String dirtyMessage;
    @Nullable
    private final LogicalType rowType;
    private final T data;

    public DirtyData(T data, String identifier, String labels, String logTag, DirtyType dirtyType, String dirtyMessage, @Nullable LogicalType rowType) {
        this.data = data;
        this.dirtyType = dirtyType;
        this.dirtyMessage = dirtyMessage;
        this.rowType = rowType;
        Map<String, String> paramMap = this.genParamMap();
        this.labels = PatternReplaceUtils.replace(labels, paramMap);
        this.logTag = PatternReplaceUtils.replace(logTag, paramMap);
        this.identifier = PatternReplaceUtils.replace(identifier, paramMap);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private Map<String, String> genParamMap() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(SYSTEM_TIME_KEY, DATE_TIME_FORMAT.format(LocalDateTime.now()));
        paramMap.put(DIRTY_TYPE_KEY, this.dirtyType.format());
        paramMap.put(DIRTY_MESSAGE_KEY, this.dirtyMessage);
        return paramMap;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLogTag() {
        return this.logTag;
    }

    public T getData() {
        return this.data;
    }

    public DirtyType getDirtyType() {
        return this.dirtyType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public LogicalType getRowType() {
        return this.rowType;
    }

    public static class Builder<T> {
        private String identifier;
        private String labels;
        private String logTag;
        private DirtyType dirtyType = DirtyType.UNDEFINED;
        private String dirtyMessage;
        private LogicalType rowType;
        private T data;

        public Builder<T> setDirtyType(DirtyType dirtyType) {
            this.dirtyType = dirtyType;
            return this;
        }

        public Builder<T> setLabels(String labels) {
            this.labels = labels;
            return this;
        }

        public Builder<T> setData(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> setLogTag(String logTag) {
            this.logTag = logTag;
            return this;
        }

        public Builder<T> setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder<T> setDirtyMessage(String dirtyMessage) {
            this.dirtyMessage = dirtyMessage;
            return this;
        }

        public Builder<T> setRowType(LogicalType rowType) {
            this.rowType = rowType;
            return this;
        }

        public DirtyData<T> build() {
            return new DirtyData<T>(this.data, this.identifier, this.labels, this.logTag, this.dirtyType, this.dirtyMessage, this.rowType);
        }
    }
}

