/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.pojo.agent;

import java.util.List;
import org.apache.flink.hbase.shaded.org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.enums.DataReportTypeEnum;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;

public class DataConfig {
    private String ip;
    private String uuid;
    private String inlongGroupId;
    private String inlongStreamId;
    private String op;
    private Integer taskId;
    private Integer taskType;
    private String taskName;
    private String snapshot;
    private Integer syncSend;
    private String syncPartitionKey;
    private String extParams;
    private Integer version;
    private String deliveryTime;
    private Integer dataReportType = 0;
    private List<MQClusterInfo> mqClusters;
    private DataProxyTopicInfo topicInfo;

    public boolean isValid() {
        DataReportTypeEnum reportType = DataReportTypeEnum.getReportType(this.dataReportType);
        if (reportType == DataReportTypeEnum.NORMAL_SEND_TO_DATAPROXY || reportType == DataReportTypeEnum.PROXY_SEND_TO_DATAPROXY) {
            return true;
        }
        return reportType == DataReportTypeEnum.DIRECT_SEND_TO_MQ && CollectionUtils.isNotEmpty(this.mqClusters) && this.mqClusters.stream().allMatch(MQClusterInfo::isValid) && this.topicInfo.isValid();
    }

    public String getIp() {
        return this.ip;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getOp() {
        return this.op;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public Integer getSyncSend() {
        return this.syncSend;
    }

    public String getSyncPartitionKey() {
        return this.syncPartitionKey;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getDeliveryTime() {
        return this.deliveryTime;
    }

    public Integer getDataReportType() {
        return this.dataReportType;
    }

    public List<MQClusterInfo> getMqClusters() {
        return this.mqClusters;
    }

    public DataProxyTopicInfo getTopicInfo() {
        return this.topicInfo;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setTaskId(Integer taskId) {
        this.taskId = taskId;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public void setSyncSend(Integer syncSend) {
        this.syncSend = syncSend;
    }

    public void setSyncPartitionKey(String syncPartitionKey) {
        this.syncPartitionKey = syncPartitionKey;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setDeliveryTime(String deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public void setDataReportType(Integer dataReportType) {
        this.dataReportType = dataReportType;
    }

    public void setMqClusters(List<MQClusterInfo> mqClusters) {
        this.mqClusters = mqClusters;
    }

    public void setTopicInfo(DataProxyTopicInfo topicInfo) {
        this.topicInfo = topicInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataConfig)) {
            return false;
        }
        DataConfig other = (DataConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$taskId = this.getTaskId();
        Integer other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$syncSend = this.getSyncSend();
        Integer other$syncSend = other.getSyncSend();
        if (this$syncSend == null ? other$syncSend != null : !((Object)this$syncSend).equals(other$syncSend)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$dataReportType = this.getDataReportType();
        Integer other$dataReportType = other.getDataReportType();
        if (this$dataReportType == null ? other$dataReportType != null : !((Object)this$dataReportType).equals(other$dataReportType)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$snapshot = this.getSnapshot();
        String other$snapshot = other.getSnapshot();
        if (this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot)) {
            return false;
        }
        String this$syncPartitionKey = this.getSyncPartitionKey();
        String other$syncPartitionKey = other.getSyncPartitionKey();
        if (this$syncPartitionKey == null ? other$syncPartitionKey != null : !this$syncPartitionKey.equals(other$syncPartitionKey)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$deliveryTime = this.getDeliveryTime();
        String other$deliveryTime = other.getDeliveryTime();
        if (this$deliveryTime == null ? other$deliveryTime != null : !this$deliveryTime.equals(other$deliveryTime)) {
            return false;
        }
        List<MQClusterInfo> this$mqClusters = this.getMqClusters();
        List<MQClusterInfo> other$mqClusters = other.getMqClusters();
        if (this$mqClusters == null ? other$mqClusters != null : !((Object)this$mqClusters).equals(other$mqClusters)) {
            return false;
        }
        DataProxyTopicInfo this$topicInfo = this.getTopicInfo();
        DataProxyTopicInfo other$topicInfo = other.getTopicInfo();
        return !(this$topicInfo == null ? other$topicInfo != null : !this$topicInfo.equals(other$topicInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $syncSend = this.getSyncSend();
        result = result * 59 + ($syncSend == null ? 43 : ((Object)$syncSend).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $dataReportType = this.getDataReportType();
        result = result * 59 + ($dataReportType == null ? 43 : ((Object)$dataReportType).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $snapshot = this.getSnapshot();
        result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
        String $syncPartitionKey = this.getSyncPartitionKey();
        result = result * 59 + ($syncPartitionKey == null ? 43 : $syncPartitionKey.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $deliveryTime = this.getDeliveryTime();
        result = result * 59 + ($deliveryTime == null ? 43 : $deliveryTime.hashCode());
        List<MQClusterInfo> $mqClusters = this.getMqClusters();
        result = result * 59 + ($mqClusters == null ? 43 : ((Object)$mqClusters).hashCode());
        DataProxyTopicInfo $topicInfo = this.getTopicInfo();
        result = result * 59 + ($topicInfo == null ? 43 : $topicInfo.hashCode());
        return result;
    }

    public String toString() {
        return "DataConfig(ip=" + this.getIp() + ", uuid=" + this.getUuid() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", op=" + this.getOp() + ", taskId=" + this.getTaskId() + ", taskType=" + this.getTaskType() + ", taskName=" + this.getTaskName() + ", snapshot=" + this.getSnapshot() + ", syncSend=" + this.getSyncSend() + ", syncPartitionKey=" + this.getSyncPartitionKey() + ", extParams=" + this.getExtParams() + ", version=" + this.getVersion() + ", deliveryTime=" + this.getDeliveryTime() + ", dataReportType=" + this.getDataReportType() + ", mqClusters=" + this.getMqClusters() + ", topicInfo=" + this.getTopicInfo() + ")";
    }
}

