/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.protocol;

import org.apache.flink.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.hbase.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.inlong.audit.protocol.AuditApi;

public class Commands {
    public static int HEAD_LENGTH = 4;

    public static ByteBuf getPongChannelBuffer() {
        AuditApi.BaseCommand cmdPong = AuditApi.BaseCommand.newBuilder().setType(AuditApi.BaseCommand.Type.PONG).setPong(AuditApi.Pong.getDefaultInstance()).build();
        return Commands.getChannelBuffer(cmdPong.toByteArray());
    }

    public static ByteBuf getPingChannelBuffer() {
        AuditApi.BaseCommand cmdPing = AuditApi.BaseCommand.newBuilder().setType(AuditApi.BaseCommand.Type.PING).setPong(AuditApi.Pong.getDefaultInstance()).build();
        return Commands.getChannelBuffer(cmdPing.toByteArray());
    }

    public static ByteBuf getAuditRequestBuffer(AuditApi.AuditRequest auditRequest) {
        AuditApi.BaseCommand cmdAuditRequest = AuditApi.BaseCommand.newBuilder().setType(AuditApi.BaseCommand.Type.AUDIT_REQUEST).setAuditRequest(auditRequest).build();
        return Commands.getChannelBuffer(cmdAuditRequest.toByteArray());
    }

    public static ByteBuf getAuditReplyBuffer(AuditApi.AuditReply auditReply) {
        AuditApi.BaseCommand cmdAuditReply = AuditApi.BaseCommand.newBuilder().setType(AuditApi.BaseCommand.Type.AUDIT_REPLY).setAuditReply(auditReply).build();
        return Commands.getChannelBuffer(cmdAuditReply.toByteArray());
    }

    private static ByteBuf getChannelBuffer(byte[] body) {
        int totalLength = body.length;
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(HEAD_LENGTH + totalLength);
        buffer.writeInt(totalLength);
        buffer.writeBytes(body);
        return buffer;
    }
}

