/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.file.holder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.hbase.shaded.org.apache.commons.io.FileUtils;
import org.apache.inlong.audit.file.ConfigHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesConfigHolder
extends ConfigHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesConfigHolder.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Map<String, String> holder;

    public PropertiesConfigHolder(String fileName, boolean needToCheckChanged) {
        super(fileName, needToCheckChanged);
    }

    @Override
    public void loadFromFileToHolder() {
        this.readWriteLock.readLock().lock();
        try {
            Map<String, String> tmpHolder = this.loadProperties();
            LOG.info(this.getFileName() + " load content {}", tmpHolder);
            this.holder = tmpHolder;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Map<String, String> forkHolder() {
        HashMap<String, String> tmpHolder = new HashMap<String, String>();
        if (this.holder != null) {
            for (Map.Entry<String, String> entry : this.holder.entrySet()) {
                tmpHolder.put(entry.getKey(), entry.getValue());
            }
        }
        return tmpHolder;
    }

    private List<String> getStringListFromHolder(Map<String, String> tmpHolder) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : tmpHolder.entrySet()) {
            result.add(entry.getKey() + "=" + entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFromHolderToFile(Map<String, String> tmpHolder) {
        this.readWriteLock.writeLock().lock();
        boolean isSuccess = false;
        try {
            File sourceFile = new File(this.getFilePath());
            File targetFile = new File(this.getNextBackupFileName());
            File tmpNewFile = new File(this.getFileName() + ".tmp");
            if (sourceFile.exists()) {
                FileUtils.copyFile((File)sourceFile, (File)targetFile);
            }
            List<String> lines = this.getStringListFromHolder(tmpHolder);
            FileUtils.writeLines((File)tmpNewFile, lines);
            FileUtils.copyFile((File)tmpNewFile, (File)sourceFile);
            tmpNewFile.delete();
            isSuccess = true;
            this.getFileChanged().set(true);
        }
        catch (Exception ex) {
            LOG.error("error in writing file", (Throwable)ex);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> loadProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        InputStream inStream = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(this.getFileName());
            InputStream inputStream = inStream = url != null ? url.openStream() : null;
            if (inStream == null) {
                LOG.error("InputStream {} is null!", (Object)this.getFileName());
            }
            Properties props = new Properties();
            props.load(inStream);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("fail to load properties, file ={}, and e= {}", (Object)this.getFileName(), (Object)e);
        }
        catch (Exception e) {
            LOG.error("fail to load properties, file ={}, and e= {}", (Object)this.getFileName(), (Object)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOG.error("fail to loadTopics, inStream.close ,and e= {}", (Object)this.getFileName(), (Object)e);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, String> getHolder() {
        return this.holder;
    }
}

