/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.send.SenderManager;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.audit.util.Config;
import org.apache.inlong.audit.util.StatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditOperator.class);
    private static final String FIELD_SEPARATORS = ":";
    private static final int BATCH_NUM = 100;
    private static final AuditOperator AUDIT_OPERATOR = new AuditOperator();
    private static final ReentrantLock GLOBAL_LOCK = new ReentrantLock();
    private static final int PERIOD = 60000;
    private final ConcurrentHashMap<String, StatInfo> countMap = new ConcurrentHashMap();
    private final HashMap<String, StatInfo> threadCountMap = new HashMap();
    private final ConcurrentHashMap<String, StatInfo> deleteCountMap = new ConcurrentHashMap();
    private final List<String> deleteKeyList = new ArrayList<String>();
    private final Config config = new Config();
    private final Timer timer = new Timer();
    private int packageId = 1;
    private int dataId = 0;
    private boolean initialized = false;
    private SenderManager manager;
    private final TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                AuditOperator.this.send();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    };
    private AuditConfig auditConfig = null;

    private AuditOperator() {
    }

    public static AuditOperator getInstance() {
        return AUDIT_OPERATOR;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.config.init();
        this.timer.schedule(this.timerTask, 60000L, 60000L);
        if (this.auditConfig == null) {
            this.auditConfig = new AuditConfig();
        }
        this.manager = new SenderManager(this.auditConfig);
    }

    public void setAuditProxy(HashSet<String> ipPortList) {
        try {
            GLOBAL_LOCK.lockInterruptibly();
            if (!this.initialized) {
                this.init();
                this.initialized = true;
            }
            this.manager.setAuditProxy(ipPortList);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            GLOBAL_LOCK.unlock();
        }
    }

    public void setAuditConfig(AuditConfig config) {
        this.auditConfig = config;
        this.manager.setAuditConfig(config);
    }

    public void add(int auditID, String inlongGroupID, String inlongStreamID, Long logTime, long count, long size) {
        long delayTime = System.currentTimeMillis() - logTime;
        String key = logTime / 60000L + FIELD_SEPARATORS + inlongGroupID + FIELD_SEPARATORS + inlongStreamID + FIELD_SEPARATORS + auditID;
        this.addByKey(key, count, size, delayTime);
    }

    private void addByKey(String key, long count, long size, long delayTime) {
        if (this.countMap.get(key) == null) {
            this.countMap.put(key, new StatInfo(0L, 0L, 0L));
        }
        this.countMap.get((Object)key).count.addAndGet(count);
        this.countMap.get((Object)key).size.addAndGet(size);
        this.countMap.get((Object)key).delay.addAndGet(delayTime * count);
    }

    public synchronized void send() {
        this.manager.clearBuffer();
        this.resetStat();
        for (Map.Entry<String, StatInfo> entry : this.deleteCountMap.entrySet()) {
            this.sumThreadGroup(entry.getKey(), entry.getValue());
        }
        this.deleteCountMap.clear();
        for (Map.Entry<String, StatInfo> entry : this.countMap.entrySet()) {
            String key = entry.getKey();
            StatInfo value = entry.getValue();
            if (value.count.get() == 0L) {
                this.deleteKeyList.add(key);
                continue;
            }
            this.sumThreadGroup(key, value);
        }
        for (String key : this.deleteKeyList) {
            StatInfo value = this.countMap.remove(key);
            this.deleteCountMap.put(key, value);
        }
        this.deleteKeyList.clear();
        long sdkTime = Calendar.getInstance().getTimeInMillis();
        AuditApi.AuditMessageHeader msgHeader = AuditApi.AuditMessageHeader.newBuilder().setIp(this.config.getLocalIP()).setDockerId(this.config.getDockerId()).setThreadId(String.valueOf(Thread.currentThread().getId())).setSdkTs(sdkTime).setPacketId(this.packageId).build();
        AuditApi.AuditRequest.Builder requestBuild = AuditApi.AuditRequest.newBuilder();
        requestBuild.setMsgHeader(msgHeader).setRequestId(this.manager.nextRequestId());
        for (Map.Entry<String, StatInfo> entry : this.threadCountMap.entrySet()) {
            String[] keyArray = entry.getKey().split(FIELD_SEPARATORS);
            long logTime = Long.parseLong(keyArray[0]) * 60000L;
            String inlongGroupID = keyArray[1];
            String inlongStreamID = keyArray[2];
            String auditID = keyArray[3];
            StatInfo value = entry.getValue();
            AuditApi.AuditMessageBody msgBody = AuditApi.AuditMessageBody.newBuilder().setLogTs(logTime).setInlongGroupId(inlongGroupID).setInlongStreamId(inlongStreamID).setAuditId(auditID).setCount(value.count.get()).setSize(value.size.get()).setDelay(value.delay.get()).build();
            requestBuild.addMsgBody(msgBody);
            if (this.dataId++ < 100) continue;
            this.dataId = 0;
            ++this.packageId;
            this.sendByBaseCommand(requestBuild.build());
            requestBuild.clearMsgBody();
        }
        if (requestBuild.getMsgBodyCount() > 0) {
            this.sendByBaseCommand(requestBuild.build());
            requestBuild.clearMsgBody();
        }
        this.threadCountMap.clear();
        LOGGER.info("finish report audit data");
    }

    private void sendByBaseCommand(AuditApi.AuditRequest auditRequest) {
        AuditApi.BaseCommand.Builder baseCommand = AuditApi.BaseCommand.newBuilder();
        baseCommand.setType(AuditApi.BaseCommand.Type.AUDIT_REQUEST).setAuditRequest(auditRequest).build();
        this.manager.send(baseCommand.build());
    }

    private void sumThreadGroup(String key, StatInfo statInfo) {
        long count = statInfo.count.getAndSet(0L);
        if (0L == count) {
            return;
        }
        if (this.threadCountMap.get(key) == null) {
            this.threadCountMap.put(key, new StatInfo(0L, 0L, 0L));
        }
        long size = statInfo.size.getAndSet(0L);
        long delay = statInfo.delay.getAndSet(0L);
        this.threadCountMap.get((Object)key).count.addAndGet(count);
        this.threadCountMap.get((Object)key).size.addAndGet(size);
        this.threadCountMap.get((Object)key).delay.addAndGet(delay);
    }

    private void resetStat() {
        this.dataId = 0;
        this.packageId = 1;
    }
}

