/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types;

import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Order;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class OrderedInt8
extends OrderedBytesBase<Byte> {
    public static final OrderedInt8 ASCENDING = new OrderedInt8(Order.ASCENDING);
    public static final OrderedInt8 DESCENDING = new OrderedInt8(Order.DESCENDING);

    protected OrderedInt8(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Byte val) {
        return 2;
    }

    @Override
    public Class<Byte> encodedClass() {
        return Byte.class;
    }

    @Override
    public Byte decode(PositionedByteRange src) {
        return OrderedBytes.decodeInt8(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Byte val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeInt8(dst, val, this.order);
    }

    public byte decodeByte(PositionedByteRange src) {
        return OrderedBytes.decodeInt8(src);
    }

    public int encodeByte(PositionedByteRange dst, byte val) {
        return OrderedBytes.encodeInt8(dst, val, this.order);
    }
}

