/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.flink.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Cursor;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.conf.Configuration;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ClientScanner
extends AbstractClientScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClientScanner.class);
    protected final Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected ScannerCallableWithReplicas callable = null;
    protected Queue<Result> cache;
    private final ScanResultCache scanResultCache;
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final ClusterConnection connection;
    protected final TableName tableName;
    protected final int scannerTimeout;
    protected boolean scanMetricsPublished = false;
    protected RpcRetryingCaller<Result[]> caller;
    protected RpcControllerFactory rpcControllerFactory;
    protected Configuration conf;
    protected final int primaryOperationTimeout;
    private int retries;
    protected final ExecutorService pool;

    public ClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary(scan.getStartRow()));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.pool = pool;
        this.primaryOperationTimeout = primaryOperationTimeout;
        this.retries = conf.getInt("hbase.client.retries.number", 15);
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.scannerTimeout = conf.getInt("hbase.client.scanner.timeout.period", 60000);
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.caller = rpcFactory.newCaller();
        this.rpcControllerFactory = controllerFactory;
        this.conf = conf;
        this.scanResultCache = ConnectionUtils.createScanResultCache(scan);
        this.initCache();
    }

    protected ClusterConnection getConnection() {
        return this.connection;
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected int getScannerTimeout() {
        return this.scannerTimeout;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    protected int getPrimaryOperationTimeout() {
        return this.primaryOperationTimeout;
    }

    protected int getCaching() {
        return this.caching;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    @VisibleForTesting
    protected long getMaxResultSize() {
        return this.maxScannerResultSize;
    }

    private void closeScanner() throws IOException {
        if (this.callable != null) {
            this.callable.setClose();
            this.call(this.callable, this.caller, this.scannerTimeout, false);
            this.callable = null;
        }
    }

    protected abstract boolean setNewStartKey();

    protected abstract ScannerCallable createScannerCallable();

    @VisibleForTesting
    protected boolean moveToNextRegion() {
        block6: {
            try {
                this.closeScanner();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("close scanner for " + this.currentRegion + " failed", (Throwable)e);
            }
        }
        if (this.currentRegion != null) {
            if (!this.setNewStartKey()) {
                return false;
            }
            this.scan.resetMvccReadPoint();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Finished " + this.currentRegion);
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(this.scan.getStartRow()) + "', " + (this.scan.includeStartRow() ? "inclusive" : "exclusive"));
        }
        this.currentRegion = null;
        this.callable = new ScannerCallableWithReplicas(this.getTable(), this.getConnection(), this.createScannerCallable(), this.pool, this.primaryOperationTimeout, this.scan, this.getRetries(), this.scannerTimeout, this.caching, this.conf, this.caller);
        this.callable.setCaching(this.caching);
        ConnectionUtils.incRegionCountMetrics(this.scanMetrics);
        return true;
    }

    @VisibleForTesting
    boolean isAnyRPCcancelled() {
        return this.callable.isAnyRPCcancelled();
    }

    private Result[] call(ScannerCallableWithReplicas callable, RpcRetryingCaller<Result[]> caller, int scannerTimeout, boolean updateCurrentRegion) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        Result[] rrs = caller.callWithoutRetries(callable, scannerTimeout);
        if (this.currentRegion == null && updateCurrentRegion) {
            this.currentRegion = callable.getHRegionInfo();
        }
        return rrs;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        this.scan.setAttribute("scan.attributes.metrics.data", ProtobufUtil.toScanMetrics(this.scanMetrics, false).toByteArray());
        this.scanMetricsPublished = true;
    }

    protected void initSyncCache() {
        this.cache = new ArrayDeque<Result>();
    }

    protected Result nextWithSyncCache() throws IOException {
        Result result = this.cache.poll();
        if (result != null) {
            return result;
        }
        if (this.closed) {
            return null;
        }
        this.loadCache();
        result = this.cache.poll();
        if (result == null) {
            this.writeScanMetrics();
        }
        return result;
    }

    @VisibleForTesting
    public int getCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    private boolean scanExhausted(Result[] values) {
        return this.callable.moreResultsForScan() == ScannerCallable.MoreResults.NO;
    }

    private boolean regionExhausted(Result[] values) {
        return values.length == 0 && !this.callable.isHeartbeatMessage() || this.callable.moreResultsInRegion() == ScannerCallable.MoreResults.NO;
    }

    private void closeScannerIfExhausted(boolean exhausted) throws IOException {
        if (exhausted) {
            this.closeScanner();
        }
    }

    private void handleScanError(DoNotRetryIOException e, MutableBoolean retryAfterOutOfOrderException, int retriesLeft) throws DoNotRetryIOException {
        this.scanResultCache.clear();
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException || e instanceof UnknownScannerException || e instanceof ScannerResetException || e instanceof LeaseException) {
            if (retriesLeft <= 0) {
                throw e;
            }
        } else {
            throw e;
        }
        if (this.lastResult != null) {
            this.scan.withStartRow(this.lastResult.getRow(), this.lastResult.mayHaveMoreCellsInRow());
        }
        if (e instanceof OutOfOrderScannerNextException) {
            if (retryAfterOutOfOrderException.isTrue()) {
                retryAfterOutOfOrderException.setValue(false);
            } else {
                throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", e);
            }
        }
        this.currentRegion = null;
        this.callable = null;
    }

    protected void loadCache() throws IOException {
        block18: {
            if (this.closed) {
                return;
            }
            long remainingResultSize = this.maxScannerResultSize;
            int countdown = this.caching;
            if (this.callable == null && !this.moveToNextRegion()) {
                this.closed = true;
                return;
            }
            MutableBoolean retryAfterOutOfOrderException = new MutableBoolean(true);
            int retriesLeft = this.getRetries();
            while (true) {
                Result[] values;
                try {
                    values = this.call(this.callable, this.caller, this.scannerTimeout, true);
                    if (this.callable.switchedToADifferentReplica()) {
                        this.scanResultCache.clear();
                        this.currentRegion = this.callable.getHRegionInfo();
                    }
                    retryAfterOutOfOrderException.setValue(true);
                }
                catch (DoNotRetryIOException e) {
                    this.handleScanError(e, retryAfterOutOfOrderException, retriesLeft--);
                    if (this.moveToNextRegion()) continue;
                    break block18;
                }
                long currentTime = System.currentTimeMillis();
                if (this.scanMetrics != null) {
                    this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
                }
                this.lastNext = currentTime;
                int numberOfCompleteRowsBefore = this.scanResultCache.numberOfCompleteRows();
                Result[] resultsToAddToCache = this.scanResultCache.addAndGet(values, this.callable.isHeartbeatMessage());
                int numberOfCompleteRows = this.scanResultCache.numberOfCompleteRows() - numberOfCompleteRowsBefore;
                for (Result rs : resultsToAddToCache) {
                    this.cache.add(rs);
                    long estimatedHeapSizeOfResult = ConnectionUtils.calcEstimatedSize(rs);
                    --countdown;
                    remainingResultSize -= estimatedHeapSizeOfResult;
                    this.addEstimatedSize(estimatedHeapSizeOfResult);
                    this.lastResult = rs;
                }
                if (this.scan.getLimit() > 0) {
                    int newLimit = this.scan.getLimit() - numberOfCompleteRows;
                    assert (newLimit >= 0);
                    this.scan.setLimit(newLimit);
                }
                if (this.scan.getLimit() == 0 || this.scanExhausted(values)) {
                    this.closeScanner();
                    this.closed = true;
                    break block18;
                }
                boolean regionExhausted = this.regionExhausted(values);
                if (this.callable.isHeartbeatMessage() && !this.cache.isEmpty()) {
                    LOG.trace("Heartbeat message received and cache contains Results. Breaking out of scan loop");
                    break block18;
                }
                if (this.cache.isEmpty() && !this.closed && this.scan.isNeedCursorResult()) {
                    if (this.callable.isHeartbeatMessage() && this.callable.getCursor() != null) {
                        this.cache.add(Result.createCursorResult(this.callable.getCursor()));
                        break block18;
                    }
                    if (values.length > 0) {
                        this.cache.add(Result.createCursorResult(new Cursor(values[values.length - 1].getRow())));
                        break block18;
                    }
                }
                if (countdown <= 0) {
                    this.closeScannerIfExhausted(regionExhausted);
                    break block18;
                }
                if (remainingResultSize <= 0L) {
                    if (!this.cache.isEmpty()) {
                        this.closeScannerIfExhausted(regionExhausted);
                        break block18;
                    }
                    remainingResultSize = this.maxScannerResultSize;
                }
                if (regionExhausted && !this.moveToNextRegion()) break;
            }
            this.closed = true;
        }
    }

    protected void addEstimatedSize(long estimatedHeapSizeOfResult) {
    }

    @VisibleForTesting
    public int getCacheCount() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.call(this.callable, this.caller, this.scannerTimeout, false);
            }
            catch (UnknownScannerException e) {
                LOG.debug("scanner failed to close", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("scanner failed to close.", (Throwable)e);
            }
            this.callable = null;
        }
        this.closed = true;
    }

    @Override
    public boolean renewLease() {
        if (this.callable == null) {
            return false;
        }
        this.callable.setRenew(true);
        try {
            this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug("scanner failed to renew lease", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.callable.setRenew(false);
        }
    }

    protected void initCache() {
        this.initSyncCache();
    }

    @Override
    public Result next() throws IOException {
        return this.nextWithSyncCache();
    }
}

