/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase2.source;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.connector.hbase2.source.AbstractTableInputFormat;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableName;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Result;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.conf.Configuration;

@Experimental
public abstract class HBaseInputFormat<T extends Tuple>
extends AbstractTableInputFormat<T> {
    private static final long serialVersionUID = 1L;

    public HBaseInputFormat(Configuration hConf) {
        super(hConf);
    }

    @Override
    protected abstract Scan getScanner();

    @Override
    protected abstract String getTableName();

    protected abstract T mapResultToTuple(Result var1);

    @Override
    protected void initTable() {
        if (this.table == null) {
            this.createTable();
        }
        if (this.table != null && this.scan == null) {
            this.scan = this.getScanner();
        }
    }

    private void createTable() {
        try {
            if (this.connection == null) {
                this.connection = ConnectionFactory.createConnection(this.getHadoopConfiguration());
            }
            TableName name = TableName.valueOf(this.getTableName());
            this.table = this.connection.getTable(name);
            this.regionLocator = this.connection.getRegionLocator(name);
        }
        catch (TableNotFoundException tnfe) {
            LOG.error("The table " + this.table.getName().getNameAsString() + " not found ", (Throwable)tnfe);
            throw new RuntimeException("HBase table '" + this.table.getName().getNameAsString() + "' not found.", tnfe);
        }
        catch (Exception e) {
            throw new RuntimeException("Error connecting to the HBase table", e);
        }
    }

    @Override
    protected T mapResultToOutType(Result r) {
        return this.mapResultToTuple(r);
    }
}

