/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.sink;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.hbase.sink.HBaseMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseReadWriteHelper;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.hbase.shaded.org.apache.hadoop.hbase.client.Mutation;
import org.apache.flink.types.Row;

public class LegacyMutationConverter
implements HBaseMutationConverter<Tuple2<Boolean, Row>> {
    private static final long serialVersionUID = 7358222494016900667L;
    private final HBaseTableSchema schema;
    private transient HBaseReadWriteHelper helper;

    public LegacyMutationConverter(HBaseTableSchema schema) {
        this.schema = schema;
    }

    @Override
    public void open() {
        this.helper = new HBaseReadWriteHelper(this.schema);
    }

    @Override
    public Mutation convertToMutation(Tuple2<Boolean, Row> record) {
        if (((Boolean)record.f0).booleanValue()) {
            return this.helper.createPutMutation((Row)record.f1);
        }
        return this.helper.createDeleteMutation((Row)record.f1);
    }
}

