/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedEncodingFormat;

public class CanalJsonEnhancedSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final StringData OP_INSERT = StringData.fromString((String)"INSERT");
    private static final StringData OP_DELETE = StringData.fromString((String)"DELETE");
    private final JsonRowDataSerializationSchema jsonSerializer;
    private final RowData.FieldGetter[] physicalFieldGetter;
    private final RowData.FieldGetter[] wirteableMetadataFieldGetter;
    private final RowType jsonRowType;
    private transient GenericRowData reuse;

    public CanalJsonEnhancedSerializationSchema(DataType physicalDataType, final List<CanalJsonEnhancedEncodingFormat.WriteableMetadata> writeableMetadata, TimestampFormat timestampFormat, JsonOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber) {
        final List physicalChildren = physicalDataType.getLogicalType().getChildren();
        this.jsonRowType = CanalJsonEnhancedSerializationSchema.createJsonRowType(physicalDataType, writeableMetadata);
        this.physicalFieldGetter = (RowData.FieldGetter[])IntStream.range(0, physicalChildren.size()).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
        this.wirteableMetadataFieldGetter = (RowData.FieldGetter[])IntStream.range(physicalChildren.size(), physicalChildren.size() + writeableMetadata.size()).mapToObj(targetField -> new RowData.FieldGetter(){

            @Nullable
            public Object getFieldOrNull(RowData row) {
                CanalJsonEnhancedEncodingFormat.WriteableMetadata curWriteableMetadata = (CanalJsonEnhancedEncodingFormat.WriteableMetadata)((Object)writeableMetadata.get(targetField - physicalChildren.size()));
                return curWriteableMetadata.converter.convert(row, targetField);
            }
        }).toArray(RowData.FieldGetter[]::new);
        this.jsonSerializer = new JsonRowDataSerializationSchema(this.jsonRowType, timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<CanalJsonEnhancedEncodingFormat.WriteableMetadata> writeableMetadata) {
        DataType root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)physicalDataType)), CanalJsonEnhancedEncodingFormat.WriteableMetadata.TYPE.requiredJsonField});
        List metadataFields = writeableMetadata.stream().filter(m -> m != CanalJsonEnhancedEncodingFormat.WriteableMetadata.TYPE).map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        return (RowType)DataTypeUtils.appendRowFields((DataType)root, metadataFields).getLogicalType();
    }

    public void open(SerializationSchema.InitializationContext context) {
        this.reuse = new GenericRowData(2 + this.wirteableMetadataFieldGetter.length);
    }

    public byte[] serialize(RowData row) {
        try {
            GenericRowData physicalData = new GenericRowData(this.physicalFieldGetter.length);
            IntStream.range(0, this.physicalFieldGetter.length).forEach(targetField -> physicalData.setField(targetField, this.physicalFieldGetter[targetField].getFieldOrNull(row)));
            GenericArrayData arrayData = new GenericArrayData((Object[])new RowData[]{physicalData});
            this.reuse.setField(0, (Object)arrayData);
            StringData opType = this.rowKind2String(row.getRowKind());
            this.reuse.setField(1, (Object)opType);
            IntStream.range(0, this.wirteableMetadataFieldGetter.length).forEach(targetField -> this.reuse.setField(2 + targetField, this.wirteableMetadataFieldGetter[targetField].getFieldOrNull(row)));
            return this.jsonSerializer.serialize((RowData)this.reuse);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not serialize row '" + row + "'.", t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonEnhancedSerializationSchema that = (CanalJsonEnhancedSerializationSchema)o;
        return Objects.equals(this.jsonSerializer, that.jsonSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSerializer);
    }

    private StringData rowKind2String(RowKind rowKind) {
        switch (rowKind) {
            case INSERT: 
            case UPDATE_AFTER: {
                return OP_INSERT;
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return OP_DELETE;
            }
        }
        throw new UnsupportedOperationException("Unsupported operation '" + rowKind + "' for row kind.");
    }

    static interface MetadataConverter
    extends Serializable {
        public Object convert(RowData var1, int var2);
    }
}

