/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.canal.CanalJsonOptions;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedDecodingFormat;
import org.apache.inlong.sort.formats.json.canal.CanalJsonEnhancedEncodingFormat;

public class CanalJsonEnhancedFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "canal-json-inlong";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CanalJsonOptions.validateDecodingFormatOptions((ReadableConfig)formatOptions);
        String database = formatOptions.getOptional(CanalJsonOptions.DATABASE_INCLUDE).orElse(null);
        String table = formatOptions.getOptional(CanalJsonOptions.TABLE_INCLUDE).orElse(null);
        boolean ignoreParseErrors = (Boolean)formatOptions.get(CanalJsonOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampFormat = JsonOptions.getTimestampFormat((ReadableConfig)formatOptions);
        return new CanalJsonEnhancedDecodingFormat(database, table, ignoreParseErrors, timestampFormat);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CanalJsonOptions.validateEncodingFormatOptions((ReadableConfig)formatOptions);
        TimestampFormat timestampFormat = JsonOptions.getTimestampFormat((ReadableConfig)formatOptions);
        JsonOptions.MapNullKeyMode mapNullKeyMode = JsonOptions.getMapNullKeyMode((ReadableConfig)formatOptions);
        String mapNullKeyLiteral = (String)formatOptions.get(CanalJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        boolean encodeDecimalAsPlainNumber = (Boolean)formatOptions.get(JsonOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return new CanalJsonEnhancedEncodingFormat(timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CanalJsonOptions.IGNORE_PARSE_ERRORS);
        options.add(CanalJsonOptions.TIMESTAMP_FORMAT);
        options.add(CanalJsonOptions.DATABASE_INCLUDE);
        options.add(CanalJsonOptions.TABLE_INCLUDE);
        options.add(CanalJsonOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(CanalJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        options.add(JsonOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return options;
    }
}

