/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.json.canal;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.formats.json.canal.CanalJsonDecodingFormat;
import org.apache.inlong.sort.formats.json.canal.CanalUtils;

public final class CanalJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String FIELD_OLD = "old";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_DELETE = "DELETE";
    private static final String OP_CREATE = "CREATE";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final MetadataConverter[] metadataConverters;
    private final List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata;
    private final TypeInformation<RowData> producedTypeInfo;
    @Nullable
    private final String database;
    @Nullable
    private final String table;
    private final boolean ignoreParseErrors;
    private final List<String> fieldNames;
    private final int fieldCount;
    private final Pattern databasePattern;
    private final Pattern tablePattern;

    private CanalJsonDeserializationSchema(DataType physicalDataType, List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo, @Nullable String database, @Nullable String table, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        RowType jsonRowType = CanalJsonDeserializationSchema.createJsonRowType(physicalDataType, requestedMetadata);
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(jsonRowType, producedTypeInfo, false, ignoreParseErrors, timestampFormat);
        this.metadataConverters = CanalJsonDeserializationSchema.createMetadataConverters(jsonRowType, requestedMetadata);
        this.requestedMetadata = requestedMetadata;
        this.producedTypeInfo = producedTypeInfo;
        this.database = database;
        this.table = table;
        this.ignoreParseErrors = ignoreParseErrors;
        RowType physicalRowType = (RowType)physicalDataType.getLogicalType();
        this.fieldNames = physicalRowType.getFieldNames();
        this.fieldCount = physicalRowType.getFieldCount();
        this.databasePattern = database == null ? null : Pattern.compile(database);
        this.tablePattern = table == null ? null : Pattern.compile(table);
    }

    public static Builder builder(DataType physicalDataType, List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo) {
        return new Builder(physicalDataType, requestedMetadata, producedTypeInfo);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(@Nullable byte[] message, Collector<RowData> out) throws IOException {
        block17: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                JsonNode root = this.jsonDeserializer.deserializeToJsonNode(message);
                if (this.database != null && !this.databasePattern.matcher(root.get(CanalJsonDecodingFormat.ReadableMetadata.DATABASE.key).asText()).matches()) {
                    return;
                }
                if (this.table != null && !this.tablePattern.matcher(root.get(CanalJsonDecodingFormat.ReadableMetadata.TABLE.key).asText()).matches()) {
                    return;
                }
                GenericRowData row = (GenericRowData)this.jsonDeserializer.convertToRowData(root);
                String type = row.getString(2).toString();
                if (OP_INSERT.equals(type)) {
                    ArrayData data = row.getArray(0);
                    for (int i = 0; i < data.size(); ++i) {
                        GenericRowData insert = (GenericRowData)data.getRow(i, this.fieldCount);
                        insert.setRowKind(RowKind.INSERT);
                        this.emitRow(row, insert, out);
                    }
                } else if (OP_UPDATE.equals(type)) {
                    ArrayData data = row.getArray(0);
                    ArrayData old = row.getArray(1);
                    for (int i = 0; i < data.size(); ++i) {
                        GenericRowData after = (GenericRowData)data.getRow(i, this.fieldCount);
                        GenericRowData before = (GenericRowData)old.getRow(i, this.fieldCount);
                        JsonNode oldField = root.get(FIELD_OLD);
                        for (int f = 0; f < this.fieldCount; ++f) {
                            if (!before.isNullAt(f) || oldField.findValue(this.fieldNames.get(f)) != null) continue;
                            before.setField(f, after.getField(f));
                        }
                        before.setRowKind(RowKind.UPDATE_BEFORE);
                        after.setRowKind(RowKind.UPDATE_AFTER);
                        this.emitRow(row, before, out);
                        this.emitRow(row, after, out);
                    }
                } else if (OP_DELETE.equals(type)) {
                    ArrayData data = row.getArray(0);
                    for (int i = 0; i < data.size(); ++i) {
                        GenericRowData insert = (GenericRowData)data.getRow(i, this.fieldCount);
                        insert.setRowKind(RowKind.DELETE);
                        this.emitRow(row, insert, out);
                    }
                } else {
                    if (OP_CREATE.equals(type)) {
                        return;
                    }
                    if (!this.ignoreParseErrors) {
                        throw new IOException(String.format("Unknown \"type\" value \"%s\". The Canal JSON message is '%s'", type, new String(message)));
                    }
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block17;
                throw new IOException(String.format("Corrupt Canal JSON message '%s'.", new String(message)), t);
            }
        }
    }

    private void emitRow(GenericRowData rootRow, GenericRowData physicalRow, Collector<RowData> out) {
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + 1);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos + 1, physicalRow.getField(physicalPos));
        }
        HashMap<StringData, StringData> metadataMap = new HashMap<StringData, StringData>();
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            metadataMap.put(StringData.fromString((String)CanalUtils.getMysqlMetadataKey(this.requestedMetadata.get(metadataPos))), StringData.fromString((String)this.metadataConverters[metadataPos].convert(rootRow).toString()));
        }
        producedRow.setField(0, (Object)new GenericMapData(metadataMap));
        out.collect((Object)producedRow);
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanalJsonDeserializationSchema that = (CanalJsonDeserializationSchema)o;
        return Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && Objects.equals(this.producedTypeInfo, that.producedTypeInfo) && Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table) && this.ignoreParseErrors == that.ignoreParseErrors && this.fieldCount == that.fieldCount;
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.producedTypeInfo, this.database, this.table, this.ignoreParseErrors, this.fieldCount);
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<CanalJsonDecodingFormat.ReadableMetadata> readableMetadata) {
        DataType root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)DataTypes.ARRAY((DataType)physicalDataType)), DataTypes.FIELD((String)FIELD_OLD, (DataType)DataTypes.ARRAY((DataType)physicalDataType)), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING()), CanalJsonDecodingFormat.ReadableMetadata.DATABASE.requiredJsonField, CanalJsonDecodingFormat.ReadableMetadata.TABLE.requiredJsonField});
        List rootMetadataFields = readableMetadata.stream().filter(m -> m != CanalJsonDecodingFormat.ReadableMetadata.DATABASE && m != CanalJsonDecodingFormat.ReadableMetadata.TABLE).map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        return (RowType)DataTypeUtils.appendRowFields((DataType)root, rootMetadataFields).getLogicalType();
    }

    private static MetadataConverter[] createMetadataConverters(RowType jsonRowType, List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata) {
        return (MetadataConverter[])requestedMetadata.stream().map(m -> CanalJsonDeserializationSchema.convert(jsonRowType, m)).toArray(MetadataConverter[]::new);
    }

    private static MetadataConverter convert(RowType jsonRowType, final CanalJsonDecodingFormat.ReadableMetadata metadata) {
        final int pos = jsonRowType.getFieldNames().indexOf(metadata.requiredJsonField.getName());
        return new MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData root, int unused) {
                return metadata.converter.convert(root, pos);
            }

            @Override
            public Object convert(Object in) {
                return metadata.converter.convert(in);
            }
        };
    }

    static interface MetadataConverter
    extends Serializable {
        default public Object convert(GenericRowData row) {
            return this.convert(row, -1);
        }

        public Object convert(GenericRowData var1, int var2);

        public Object convert(Object var1);
    }

    @Internal
    public static final class Builder {
        private final DataType physicalDataType;
        private final List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata;
        private final TypeInformation<RowData> producedTypeInfo;
        private String database = null;
        private String table = null;
        private boolean ignoreParseErrors = false;
        private TimestampFormat timestampFormat = TimestampFormat.SQL;

        private Builder(DataType physicalDataType, List<CanalJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo) {
            this.physicalDataType = physicalDataType;
            this.requestedMetadata = requestedMetadata;
            this.producedTypeInfo = producedTypeInfo;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setIgnoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public Builder setTimestampFormat(TimestampFormat timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public CanalJsonDeserializationSchema build() {
            return new CanalJsonDeserializationSchema(this.physicalDataType, this.requestedMetadata, this.producedTypeInfo, this.database, this.table, this.ignoreParseErrors, this.timestampFormat);
        }
    }
}

