/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.data.Envelope;
import io.debezium.relational.Table;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;
import org.apache.inlong.sort.formats.json.canal.CanalJson;
import org.apache.inlong.sort.formats.json.debezium.DebeziumJson;

public enum PostgreSQLReadableMetaData {
    TABLE_NAME("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "table"));
        }
    }),
    SCHEMA_NAME("schema_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "schema"));
        }
    }),
    DATABASE_NAME("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    DATA("meta.data", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return PostgreSQLReadableMetaData.getCanalData(record, tableSchema, (GenericRowData)rowData);
        }
    }),
    DATA_CANAL("meta.data_canal", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return PostgreSQLReadableMetaData.getCanalData(record, tableSchema, (GenericRowData)rowData);
        }
    }),
    DATA_DEBEZIUM("meta.data_debezium", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            GenericRowData data = (GenericRowData)rowData;
            Map field = (Map)data.getField(0);
            DebeziumJson.Source source = DebeziumJson.Source.builder().db(PostgreSQLReadableMetaData.getMetaData(record, "db")).table(PostgreSQLReadableMetaData.getMetaData(record, "table")).name(sourceStruct.getString("name")).sqlType(PostgreSQLReadableMetaData.getSqlType(tableSchema)).pkNames(PostgreSQLReadableMetaData.getPkNames(tableSchema)).build();
            DebeziumJson debeziumJson = DebeziumJson.builder().after(field).source(source).tsMs(sourceStruct.getInt64("ts_ms")).op(PostgreSQLReadableMetaData.getDebeziumOpType(record)).tableChange(tableSchema).build();
            try {
                return StringData.fromString((String)OBJECT_MAPPER.writeValueAsString((Object)debeziumJson));
            }
            catch (Exception e) {
                throw new IllegalStateException("exception occurs when get meta data", e);
            }
        }
    }),
    META_TABLE_NAME("meta.table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "table"));
        }
    }),
    META_SCHEMA_NAME("meta.schema_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "schema"));
        }
    }),
    META_DATABASE_NAME("meta.database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getMetaData(record, "db"));
        }
    }),
    META_OP_TS("meta.op_ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    OP_TYPE("meta.op_type", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)PostgreSQLReadableMetaData.getOpType(record));
        }
    }),
    BATCH_ID("meta.batch_id", (DataType)DataTypes.BIGINT().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;
        private long id = 0L;

        @Override
        public Object read(SourceRecord record) {
            return this.id++;
        }
    }),
    IS_DDL("meta.is_ddl", (DataType)DataTypes.BOOLEAN().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return false;
        }
    }),
    OLD("meta.update_before", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Envelope.Operation op = Envelope.operationFor(record);
            if (op != Envelope.Operation.UPDATE) {
                return null;
            }
            return record;
        }
    }),
    PK_NAMES("meta.pk_names", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            return new GenericArrayData(tableSchema.getTable().primaryKeyColumnNames().stream().map(StringData::fromString).toArray());
        }
    }),
    SQL("meta.sql", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)"");
        }
    }),
    SQL_TYPE("meta.sql_type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            HashMap postgresType = new HashMap();
            Table table = tableSchema.getTable();
            table.columns().forEach(column -> postgresType.put(StringData.fromString((String)column.name()), column.jdbcType()));
            return new GenericMapData(postgresType);
        }
    }),
    TS("meta.ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            return TimestampData.fromEpochMillis((long)((Long)messageStruct.get("ts_ms")));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;
    private static final ObjectMapper OBJECT_MAPPER;

    private static StringData getCanalData(SourceRecord record, TableChanges.TableChange tableSchema, GenericRowData rowData) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        String tableName = PostgreSQLReadableMetaData.getMetaData(record, "table");
        String databaseName = PostgreSQLReadableMetaData.getMetaData(record, "db");
        String schemaName = PostgreSQLReadableMetaData.getMetaData(record, "schema");
        long opTs = (Long)sourceStruct.get("ts_ms");
        long ts = (Long)messageStruct.get("ts_ms");
        GenericRowData data = rowData;
        Map field = (Map)data.getField(0);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        dataList.add(field);
        CanalJson canalJson = CanalJson.builder().data(dataList).database(databaseName).schema(schemaName).sql("").es(opTs).isDdl(false).pkNames(PostgreSQLReadableMetaData.getPkNames(tableSchema)).table(tableName).ts(ts).type(PostgreSQLReadableMetaData.getOpType(record)).sqlType(PostgreSQLReadableMetaData.getSqlType(tableSchema)).build();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return StringData.fromString((String)objectMapper.writeValueAsString((Object)canalJson));
        }
        catch (Exception e) {
            throw new IllegalStateException("exception occurs when get meta data", e);
        }
    }

    private PostgreSQLReadableMetaData(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    private static String getOpType(SourceRecord record) {
        Envelope.Operation op = Envelope.operationFor(record);
        String opType = op == Envelope.Operation.CREATE || op == Envelope.Operation.READ ? "INSERT" : (op == Envelope.Operation.DELETE ? "DELETE" : "UPDATE");
        return opType;
    }

    private static List<String> getPkNames(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        return tableSchema.getTable().primaryKeyColumnNames();
    }

    public static Map<String, Integer> getSqlType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, Integer> postgresType = new LinkedHashMap<String, Integer>();
        Table table = tableSchema.getTable();
        table.columns().forEach(column -> postgresType.put(column.name(), column.jdbcType()));
        return postgresType;
    }

    private static String getDebeziumOpType(SourceRecord record) {
        Envelope.Operation op = Envelope.operationFor(record);
        String opType = op == Envelope.Operation.CREATE || op == Envelope.Operation.READ ? "c" : (op == Envelope.Operation.DELETE ? "d" : "u");
        return opType;
    }

    private static String getMetaData(SourceRecord record, String tableNameKey) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        return sourceStruct.getString(tableNameKey);
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

