/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class TemporalConversions {
    static final long MILLISECONDS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    static final long MICROSECONDS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    static final long MICROSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toMicros(1L);
    static final long NANOSECONDS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_MICROSECOND = TimeUnit.MICROSECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOSECONDS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    static final long SECONDS_PER_DAY = TimeUnit.DAYS.toSeconds(1L);
    static final long MICROSECONDS_PER_DAY = TimeUnit.DAYS.toMicros(1L);
    static final LocalDate EPOCH = LocalDate.ofEpochDay(0L);

    private TemporalConversions() {
    }

    public static LocalDate toLocalDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDate) {
            return (LocalDate)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalDate();
        }
        if (obj instanceof java.sql.Date) {
            return ((java.sql.Date)obj).toLocalDate();
        }
        if (obj instanceof Time) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Time value '" + obj + "'");
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        }
        if (obj instanceof Long) {
            return LocalDate.ofEpochDay((Long)obj);
        }
        if (obj instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)obj).intValue());
        }
        throw new IllegalArgumentException("Unable to convert to LocalDate from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    public static LocalTime toLocalTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalTime) {
            return (LocalTime)obj;
        }
        if (obj instanceof LocalDateTime) {
            return ((LocalDateTime)obj).toLocalTime();
        }
        if (obj instanceof java.sql.Date) {
            throw new IllegalArgumentException("Unable to convert to LocalDate from a java.sql.Date value '" + obj + "'");
        }
        if (obj instanceof Time) {
            Time time = (Time)obj;
            long millis = (int)(time.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return LocalTime.of(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof Duration) {
            Long value = ((Duration)obj).toNanos();
            if (value >= 0L && value <= NANOSECONDS_PER_DAY) {
                return LocalTime.ofNanoOfDay(value);
            }
            throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than 86400000000000");
        }
        throw new IllegalArgumentException("Unable to convert to LocalTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    public static LocalDateTime toLocalDateTime(Object obj, ZoneId serverTimeZone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof OffsetDateTime) {
            return ((OffsetDateTime)obj).toLocalDateTime();
        }
        if (obj instanceof Instant) {
            return ((Instant)obj).atOffset(ZoneOffset.UTC).toLocalDateTime();
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof LocalDate) {
            LocalDate date = (LocalDate)obj;
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        if (obj instanceof LocalTime) {
            LocalTime time = (LocalTime)obj;
            return LocalDateTime.of(EPOCH, time);
        }
        if (obj instanceof java.sql.Date) {
            java.sql.Date sqlDate = (java.sql.Date)obj;
            LocalDate date = sqlDate.toLocalDate();
            return LocalDateTime.of(date, LocalTime.MIDNIGHT);
        }
        if (obj instanceof Time) {
            LocalTime localTime = TemporalConversions.toLocalTime(obj);
            return LocalDateTime.of(EPOCH, localTime);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return LocalDateTime.of(timestamp.getYear() + 1900, timestamp.getMonth() + 1, timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            long millis = (int)(date.getTime() % MILLISECONDS_PER_SECOND);
            if (millis < 0L) {
                millis = MILLISECONDS_PER_SECOND + millis;
            }
            int nanosOfSecond = (int)(millis * NANOSECONDS_PER_MILLISECOND);
            return LocalDateTime.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), nanosOfSecond);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            Instant instant = Instant.parse(str);
            return LocalDateTime.ofInstant(instant, serverTimeZone);
        }
        throw new IllegalArgumentException("Unable to convert to LocalDateTime from unexpected value '" + obj + "' of type " + obj.getClass().getName());
    }

    public static long toEpochMicros(Instant instant) {
        return TimeUnit.SECONDS.toMicros(instant.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(instant.getNano());
    }

    public static Instant toInstantFromMicros(long microsSinceEpoch) {
        return Instant.ofEpochSecond(TimeUnit.MICROSECONDS.toSeconds(microsSinceEpoch), TimeUnit.MICROSECONDS.toNanos(microsSinceEpoch % TimeUnit.SECONDS.toMicros(1L)));
    }
}

