/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.ConnectSchema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.data.Envelope;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.relational.history.TableChanges;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.filter.RowValidator;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table.AppendMetadataCollector;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table.DeserializationRuntimeConverter;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table.DeserializationRuntimeConverterFactory;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.util.TemporalConversions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowDataDebeziumDeserializeSchema
implements DebeziumDeserializationSchema<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(RowDataDebeziumDeserializeSchema.class);
    private static final long serialVersionUID = 2L;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ISO_DATE;
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_TIME;
    private static final ZoneId ZONE_UTC = ZoneId.of("UTC");
    private final TypeInformation<RowData> resultTypeInfo;
    private final DeserializationRuntimeConverter physicalConverter;
    private final boolean hasMetadata;
    private final boolean appendSource;
    private final AppendMetadataCollector appendMetadataCollector;
    private final RowValidator rowKindValidator;
    private boolean migrateAll;
    private ZoneId serverTimeZone;

    RowDataDebeziumDeserializeSchema(RowType physicalDataType, MetadataConverter[] metadataConverters, TypeInformation<RowData> resultTypeInfo, RowValidator rowValidator, ZoneId serverTimeZone, boolean appendSource, DeserializationRuntimeConverterFactory userDefinedConverterFactory, boolean migrateAll) {
        this.hasMetadata = ((MetadataConverter[])Preconditions.checkNotNull((Object)metadataConverters)).length > 0;
        this.appendMetadataCollector = new AppendMetadataCollector(metadataConverters, migrateAll);
        this.migrateAll = migrateAll;
        this.serverTimeZone = serverTimeZone;
        this.physicalConverter = this.createConverter((LogicalType)Preconditions.checkNotNull((Object)physicalDataType), serverTimeZone, userDefinedConverterFactory);
        this.resultTypeInfo = (TypeInformation)Preconditions.checkNotNull(resultTypeInfo);
        this.rowKindValidator = rowValidator;
        this.appendSource = (Boolean)Preconditions.checkNotNull((Object)appendSource);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static DeserializationRuntimeConverter convertToBoolean() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Boolean) {
                    return dbzObj;
                }
                if (dbzObj instanceof Byte) {
                    return (Byte)dbzObj == 1;
                }
                if (dbzObj instanceof Short) {
                    return (Short)dbzObj == 1;
                }
                return Boolean.parseBoolean(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToInt() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                if (dbzObj instanceof Long) {
                    return ((Long)dbzObj).intValue();
                }
                return Integer.parseInt(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToLong() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Integer) {
                    return ((Integer)dbzObj).longValue();
                }
                if (dbzObj instanceof Long) {
                    return dbzObj;
                }
                return Long.parseLong(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToDouble() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return ((Float)dbzObj).doubleValue();
                }
                if (dbzObj instanceof Double) {
                    return dbzObj;
                }
                return Double.parseDouble(dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToFloat() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Float) {
                    return dbzObj;
                }
                if (dbzObj instanceof Double) {
                    return Float.valueOf(((Double)dbzObj).floatValue());
                }
                return Float.valueOf(Float.parseFloat(dbzObj.toString()));
            }
        };
    }

    private static DeserializationRuntimeConverter convertToDate() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                return (int)TemporalConversions.toLocalDate(dbzObj).toEpochDay();
            }
        };
    }

    private static DeserializationRuntimeConverter convertToTime() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.MicroTime": {
                            return (int)((Long)dbzObj / 1000L);
                        }
                        case "io.debezium.time.NanoTime": {
                            return (int)((Long)dbzObj / 1000000L);
                        }
                    }
                } else if (dbzObj instanceof Integer) {
                    return dbzObj;
                }
                return TemporalConversions.toLocalTime(dbzObj).toSecondOfDay() * 1000;
            }
        };
    }

    private static DeserializationRuntimeConverter convertToTimestamp(final ZoneId serverTimeZone) {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.Timestamp": {
                            return TimestampData.fromEpochMillis((long)((Long)dbzObj));
                        }
                        case "io.debezium.time.MicroTimestamp": {
                            long micro = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(micro / 1000L), (int)((int)(micro % 1000L * 1000L)));
                        }
                        case "io.debezium.time.NanoTimestamp": {
                            long nano = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(nano / 1000000L), (int)((int)(nano % 1000000L)));
                        }
                    }
                }
                LocalDateTime localDateTime = TemporalConversions.toLocalDateTime(dbzObj, serverTimeZone);
                return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime);
            }
        };
    }

    private static DeserializationRuntimeConverter convertToLocalTimeZoneTimestamp(final ZoneId serverTimeZone) {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant instant = Instant.parse(str);
                    return TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.ofInstant(instant, serverTimeZone));
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToString() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                return StringData.fromString((String)dbzObj.toString());
            }
        };
    }

    private static DeserializationRuntimeConverter convertToBinary() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof byte[]) {
                    return dbzObj;
                }
                if (dbzObj instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)dbzObj;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + dbzObj.getClass().getSimpleName());
            }
        };
    }

    private static DeserializationRuntimeConverter createDecimalConverter(DecimalType decimalType) {
        final int precision = decimalType.getPrecision();
        final int scale = decimalType.getScale();
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                BigDecimal bigDecimal;
                if (dbzObj instanceof byte[]) {
                    bigDecimal = Decimal.toLogical(schema, (byte[])dbzObj);
                } else if (dbzObj instanceof String) {
                    bigDecimal = new BigDecimal((String)dbzObj);
                } else if (dbzObj instanceof Double) {
                    bigDecimal = BigDecimal.valueOf((Double)dbzObj);
                } else if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                    SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)dbzObj);
                    bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
                } else {
                    bigDecimal = new BigDecimal(dbzObj.toString());
                }
                return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale);
            }
        };
    }

    private static Object convertField(DeserializationRuntimeConverter fieldConverter, Object fieldValue, Schema fieldSchema) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        return fieldConverter.convert(fieldValue, fieldSchema);
    }

    private static DeserializationRuntimeConverter wrapIntoNullableConverter(final DeserializationRuntimeConverter converter) {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj == null) {
                    return null;
                }
                return converter.convert(dbzObj, schema);
            }
        };
    }

    private DeserializationRuntimeConverter createConverter(LogicalType type, ZoneId serverTimeZone, DeserializationRuntimeConverterFactory userDefinedConverterFactory) {
        return RowDataDebeziumDeserializeSchema.wrapIntoNullableConverter(this.createNotNullConverter(type, serverTimeZone, userDefinedConverterFactory));
    }

    public DeserializationRuntimeConverter createNotNullConverter(LogicalType type, ZoneId serverTimeZone, DeserializationRuntimeConverterFactory userDefinedConverterFactory) {
        Optional<DeserializationRuntimeConverter> converter = userDefinedConverterFactory.createUserDefinedConverter(type, serverTimeZone);
        if (converter.isPresent()) {
            return converter.get();
        }
        switch (type.getTypeRoot()) {
            case NULL: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object dbzObj, Schema schema) {
                        return null;
                    }
                };
            }
            case BOOLEAN: {
                return RowDataDebeziumDeserializeSchema.convertToBoolean();
            }
            case TINYINT: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object dbzObj, Schema schema) {
                        return Byte.parseByte(dbzObj.toString());
                    }
                };
            }
            case SMALLINT: {
                return new DeserializationRuntimeConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object convert(Object dbzObj, Schema schema) {
                        return Short.parseShort(dbzObj.toString());
                    }
                };
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return RowDataDebeziumDeserializeSchema.convertToInt();
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return RowDataDebeziumDeserializeSchema.convertToLong();
            }
            case DATE: {
                return RowDataDebeziumDeserializeSchema.convertToDate();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return RowDataDebeziumDeserializeSchema.convertToTime();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return RowDataDebeziumDeserializeSchema.convertToTimestamp(serverTimeZone);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RowDataDebeziumDeserializeSchema.convertToLocalTimeZoneTimestamp(serverTimeZone);
            }
            case FLOAT: {
                return RowDataDebeziumDeserializeSchema.convertToFloat();
            }
            case DOUBLE: {
                return RowDataDebeziumDeserializeSchema.convertToDouble();
            }
            case CHAR: 
            case VARCHAR: {
                return RowDataDebeziumDeserializeSchema.convertToString();
            }
            case BINARY: 
            case VARBINARY: {
                return RowDataDebeziumDeserializeSchema.convertToBinary();
            }
            case DECIMAL: {
                return RowDataDebeziumDeserializeSchema.createDecimalConverter((DecimalType)type);
            }
            case ROW: {
                return this.createRowConverter((RowType)type, serverTimeZone, userDefinedConverterFactory);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private DeserializationRuntimeConverter createRowConverter(RowType rowType, ZoneId serverTimeZone, DeserializationRuntimeConverterFactory userDefinedConverterFactory) {
        final DeserializationRuntimeConverter[] fieldConverters = (DeserializationRuntimeConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(logicType -> this.createConverter((LogicalType)logicType, serverTimeZone, userDefinedConverterFactory)).toArray(DeserializationRuntimeConverter[]::new);
        final String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        if (!this.migrateAll) {
            return new DeserializationRuntimeConverter(){
                private static final long serialVersionUID = 1L;

                @Override
                public Object convert(Object dbzObj, Schema schema) throws Exception {
                    Struct struct = (Struct)dbzObj;
                    int arity = fieldNames.length;
                    GenericRowData row = new GenericRowData(arity);
                    for (int i = 0; i < arity; ++i) {
                        String fieldName = fieldNames[i];
                        Field field = schema.field(fieldName);
                        if (field == null) {
                            row.setField(i, null);
                            continue;
                        }
                        Object fieldValue = struct.getWithoutDefault(fieldName);
                        Schema fieldSchema = schema.field(fieldName).schema();
                        Object convertedField = RowDataDebeziumDeserializeSchema.convertField(fieldConverters[i], fieldValue, fieldSchema);
                        row.setField(i, convertedField);
                    }
                    return row;
                }
            };
        }
        return this.getAllMigrationConverter();
    }

    private DeserializationRuntimeConverter getAllMigrationConverter() {
        return new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                ConnectSchema connectSchema = (ConnectSchema)schema;
                List<Field> fields = connectSchema.fields();
                HashMap<String, Object> data = new HashMap<String, Object>();
                Struct struct = (Struct)dbzObj;
                for (Field field : fields) {
                    String fieldName = field.name();
                    Object fieldValue = struct.getWithoutDefault(fieldName);
                    Schema fieldSchema = schema.field(fieldName).schema();
                    String schemaName = fieldSchema.name();
                    if (schemaName != null) {
                        fieldValue = RowDataDebeziumDeserializeSchema.this.getValueWithSchema(fieldValue, schemaName);
                    }
                    if (fieldValue instanceof ByteBuffer) {
                        fieldValue = new String(((ByteBuffer)fieldValue).array());
                    }
                    data.put(fieldName, fieldValue);
                }
                GenericRowData row = new GenericRowData(1);
                row.setField(0, data);
                return row;
            }
        };
    }

    private Object getValueWithSchema(Object fieldValue, String schemaName) {
        if (fieldValue == null) {
            return null;
        }
        switch (schemaName) {
            case "io.debezium.time.MicroTime": {
                Instant instant = Instant.ofEpochMilli((Long)fieldValue / 1000L);
                fieldValue = timeFormatter.format(LocalDateTime.ofInstant(instant, ZONE_UTC));
                break;
            }
            case "io.debezium.time.Date": {
                fieldValue = dateFormatter.format(LocalDate.ofEpochDay(((Integer)fieldValue).intValue()));
                break;
            }
            case "io.debezium.time.ZonedTimestamp": {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse((CharSequence)fieldValue);
                fieldValue = zonedDateTime.withZoneSameInstant(this.serverTimeZone).toLocalDateTime().atZone(ZONE_UTC).format(DateTimeFormatter.ISO_INSTANT);
                break;
            }
            case "io.debezium.time.Timestamp": {
                Instant instantTime = Instant.ofEpochMilli((Long)fieldValue);
                fieldValue = LocalDateTime.ofInstant(instantTime, ZONE_UTC).toString();
                break;
            }
            case "io.debezium.time.MicroTimestamp": {
                Instant instantTime = Instant.ofEpochMilli((Long)fieldValue / 1000L);
                fieldValue = LocalDateTime.ofInstant(instantTime, ZONE_UTC).toString();
                break;
            }
            case "com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal": {
                break;
            }
            default: {
                LOG.debug("schema {} is not being supported", (Object)schemaName);
            }
        }
        return fieldValue;
    }

    @Override
    public void deserialize(SourceRecord record, Collector<RowData> out) throws Exception {
        this.deserialize(record, out, (TableChanges.TableChange)null);
    }

    @Override
    public void deserialize(SourceRecord record, Collector<RowData> out, TableChanges.TableChange tableSchema) throws Exception {
        Envelope.Operation op = Envelope.operationFor(record);
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        if (op == Envelope.Operation.CREATE || op == Envelope.Operation.READ) {
            GenericRowData insert = this.extractAfterRow(value, valueSchema);
            insert.setRowKind(RowKind.INSERT);
            this.emit(record, (RowData)insert, tableSchema, out);
        } else if (op == Envelope.Operation.DELETE) {
            GenericRowData delete = this.extractBeforeRow(value, valueSchema);
            delete.setRowKind(RowKind.DELETE);
            this.emit(record, (RowData)delete, tableSchema, out);
        } else {
            GenericRowData before;
            if (!this.appendSource && (before = this.extractBeforeRow(value, valueSchema)) != null) {
                before.setRowKind(RowKind.UPDATE_BEFORE);
                this.emit(record, (RowData)before, tableSchema, out);
            }
            GenericRowData after = this.extractAfterRow(value, valueSchema);
            after.setRowKind(RowKind.UPDATE_AFTER);
            this.emit(record, (RowData)after, tableSchema, out);
        }
    }

    private GenericRowData extractAfterRow(Struct value, Schema valueSchema) throws Exception {
        Schema afterSchema = valueSchema.field("after").schema();
        Struct after = value.getStruct("after");
        return (GenericRowData)this.physicalConverter.convert(after, afterSchema);
    }

    private GenericRowData extractBeforeRow(Struct value, Schema valueSchema) throws Exception {
        Schema beforeSchema = valueSchema.field("before").schema();
        Struct before = value.getStruct("before");
        return (GenericRowData)this.physicalConverter.convert(before, beforeSchema);
    }

    private void emit(SourceRecord inRecord, RowData physicalRow, TableChanges.TableChange tableChange, Collector<RowData> collector) {
        if (!this.rowKindValidator.validate(physicalRow.getRowKind())) {
            return;
        }
        if (this.appendSource) {
            physicalRow.setRowKind(RowKind.INSERT);
        }
        if (!this.hasMetadata) {
            collector.collect((Object)physicalRow);
            return;
        }
        this.appendMetadataCollector.inputRecord = inRecord;
        this.appendMetadataCollector.outputCollector = collector;
        this.appendMetadataCollector.collect(physicalRow, tableChange);
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public static class Builder {
        private RowType physicalRowType;
        private TypeInformation<RowData> resultTypeInfo;
        private MetadataConverter[] metadataConverters = new MetadataConverter[0];
        private RowValidator rowValidator;
        private ZoneId serverTimeZone = ZoneId.of("UTC");
        private boolean appendSource = false;
        private boolean migrateAll = false;
        private DeserializationRuntimeConverterFactory userDefinedConverterFactory = DeserializationRuntimeConverterFactory.DEFAULT;

        public Builder setPhysicalRowType(RowType physicalRowType) {
            this.physicalRowType = physicalRowType;
            return this;
        }

        public Builder setMigrateAll(boolean migrateAll) {
            this.migrateAll = migrateAll;
            return this;
        }

        public Builder setMetadataConverters(MetadataConverter[] metadataConverters) {
            this.metadataConverters = metadataConverters;
            return this;
        }

        public Builder setResultTypeInfo(TypeInformation<RowData> resultTypeInfo) {
            this.resultTypeInfo = resultTypeInfo;
            return this;
        }

        public Builder setValidator(RowValidator rowFilter) {
            this.rowValidator = rowFilter;
            return this;
        }

        public Builder setServerTimeZone(ZoneId serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder setAppendSource(boolean appendSource) {
            this.appendSource = appendSource;
            return this;
        }

        public Builder setUserDefinedConverterFactory(DeserializationRuntimeConverterFactory userDefinedConverterFactory) {
            this.userDefinedConverterFactory = userDefinedConverterFactory;
            return this;
        }

        public RowDataDebeziumDeserializeSchema build() {
            return new RowDataDebeziumDeserializeSchema(this.physicalRowType, this.metadataConverters, this.resultTypeInfo, this.rowValidator, this.serverTimeZone, this.appendSource, this.userDefinedConverterFactory, this.migrateAll);
        }
    }
}

