/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.internal;

import io.debezium.document.Document;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;
import javax.annotation.Nullable;

public class SchemaRecord {
    @Nullable
    private final HistoryRecord historyRecord;
    @Nullable
    private final Document tableChangeDoc;

    public SchemaRecord(HistoryRecord historyRecord) {
        this.historyRecord = historyRecord;
        this.tableChangeDoc = null;
    }

    public SchemaRecord(Document document) {
        if (this.isHistoryRecordDocument(document)) {
            this.historyRecord = new HistoryRecord(document);
            this.tableChangeDoc = null;
        } else {
            this.tableChangeDoc = document;
            this.historyRecord = null;
        }
    }

    @Nullable
    public HistoryRecord getHistoryRecord() {
        return this.historyRecord;
    }

    @Nullable
    public Document getTableChangeDoc() {
        return this.tableChangeDoc;
    }

    public boolean isHistoryRecord() {
        return this.historyRecord != null;
    }

    public boolean isTableChangeRecord() {
        return this.tableChangeDoc != null;
    }

    public Document toDocument() {
        if (this.historyRecord != null) {
            return this.historyRecord.document();
        }
        return this.tableChangeDoc;
    }

    public String toString() {
        try {
            return DocumentWriter.defaultWriter().write(this.toDocument());
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    private boolean isHistoryRecordDocument(Document document) {
        return new HistoryRecord(document).isValid();
    }
}

