/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.internal;

import io.debezium.config.Configuration;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryException;
import io.debezium.relational.history.DatabaseHistoryListener;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.TableChanges;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.history.FlinkJsonTableChangeSerializer;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.internal.FlinkDatabaseHistory;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.internal.SchemaRecord;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.util.DatabaseHistoryUtil;

public class FlinkDatabaseSchemaHistory
implements DatabaseHistory {
    public static final String DATABASE_HISTORY_INSTANCE_NAME = "database.history.instance.name";
    private final FlinkJsonTableChangeSerializer tableChangesSerializer = new FlinkJsonTableChangeSerializer();
    public static ConcurrentMap<TableId, SchemaRecord> latestTables;
    private String instanceName;
    private DatabaseHistoryListener listener;
    private boolean storeOnlyMonitoredTablesDdl;
    private boolean skipUnparseableDDL;
    private boolean useCatalogBeforeSchema;

    public static boolean isCompatible(Collection<SchemaRecord> records) {
        SchemaRecord record;
        Iterator<SchemaRecord> iterator = records.iterator();
        return !iterator.hasNext() || (record = iterator.next()).isTableChangeRecord();
    }

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, DatabaseHistoryListener listener, boolean useCatalogBeforeSchema) {
        this.instanceName = config.getString(DATABASE_HISTORY_INSTANCE_NAME);
        this.listener = listener;
        this.storeOnlyMonitoredTablesDdl = config.getBoolean(STORE_ONLY_MONITORED_TABLES_DDL);
        this.skipUnparseableDDL = config.getBoolean(SKIP_UNPARSEABLE_DDL_STATEMENTS);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        latestTables = new ConcurrentHashMap<TableId, SchemaRecord>(6);
        for (SchemaRecord schemaRecord : DatabaseHistoryUtil.retrieveHistory(this.instanceName)) {
            TableChanges.TableChange tableChange = FlinkJsonTableChangeSerializer.fromDocument(schemaRecord.toDocument(), useCatalogBeforeSchema);
            latestTables.put(tableChange.getId(), schemaRecord);
        }
        DatabaseHistoryUtil.registerHistory(this.instanceName, latestTables.values());
    }

    @Override
    public void start() {
        this.listener.started();
    }

    @Override
    public void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String ddl) throws DatabaseHistoryException {
        throw new UnsupportedOperationException(String.format("The %s cannot work with 'debezium.internal.implementation' = 'legacy',please use %s", FlinkDatabaseSchemaHistory.class.getCanonicalName(), FlinkDatabaseHistory.class.getCanonicalName()));
    }

    @Override
    public void record(Map<String, ?> source, Map<String, ?> position, String databaseName, String schemaName, String ddl, TableChanges changes) throws DatabaseHistoryException {
        block4: for (TableChanges.TableChange change : changes) {
            switch (change.getType()) {
                case CREATE: 
                case ALTER: {
                    latestTables.put(change.getId(), new SchemaRecord(this.tableChangesSerializer.toDocument(change)));
                    continue block4;
                }
                case DROP: {
                    latestTables.remove(change.getId());
                    continue block4;
                }
            }
            throw new RuntimeException(String.format("Unknown change type: %s.", new Object[]{change.getType()}));
        }
        this.listener.onChangeApplied(new HistoryRecord(source, position, databaseName, schemaName, ddl, changes));
    }

    @Override
    public void recover(Map<String, ?> source, Map<String, ?> position, Tables schema, DdlParser ddlParser) {
        this.listener.recoveryStarted();
        for (SchemaRecord record : latestTables.values()) {
            TableChanges.TableChange tableChange = FlinkJsonTableChangeSerializer.fromDocument(record.getTableChangeDoc(), this.useCatalogBeforeSchema);
            schema.overwriteTable(tableChange.getTable());
        }
        this.listener.recoveryStopped();
    }

    @Override
    public void stop() {
        if (this.instanceName != null) {
            DatabaseHistoryUtil.removeHistory(this.instanceName);
        }
        this.listener.stopped();
    }

    @Override
    public boolean exists() {
        return latestTables != null && !latestTables.isEmpty();
    }

    @Override
    public boolean storageExists() {
        return true;
    }

    @Override
    public void initializeStorage() {
    }

    @Override
    public boolean storeOnlyMonitoredTables() {
        return this.storeOnlyMonitoredTablesDdl;
    }

    @Override
    public boolean skipUnparseableDdlStatements() {
        return this.skipUnparseableDDL;
    }
}

