/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.sink;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableMap;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.sink.TableChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleSinkOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MultipleSinkOption.class);
    private final String format;
    private boolean sparkEngineEnable;
    private final SchemaUpdateExceptionPolicy schemaUpdatePolicy;
    private final String databasePattern;
    private final String tablePattern;
    private final boolean pkAutoGenerated;

    public MultipleSinkOption(String format, boolean sparkEngineEnable, SchemaUpdateExceptionPolicy schemaUpdatePolicy, String databasePattern, String tablePattern, boolean pkAutoGenerated) {
        this.format = format;
        this.sparkEngineEnable = sparkEngineEnable;
        this.schemaUpdatePolicy = schemaUpdatePolicy;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.pkAutoGenerated = pkAutoGenerated;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isSparkEngineEnable() {
        return this.sparkEngineEnable;
    }

    public Map<String, String> getFormatOption() {
        return ImmutableMap.of(Constants.SINK_MULTIPLE_TYPE_MAP_COMPATIBLE_WITH_SPARK.key(), String.valueOf(this.isSparkEngineEnable()));
    }

    public SchemaUpdateExceptionPolicy getSchemaUpdatePolicy() {
        return this.schemaUpdatePolicy;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public boolean isPkAutoGenerated() {
        return this.pkAutoGenerated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean canHandleWithSchemaUpdate(String tableName, TableChange tableChange, SchemaUpdateExceptionPolicy policy) {
        if (SchemaUpdateExceptionPolicy.TRY_IT_BEST.equals((Object)policy)) {
            return true;
        }
        if (SchemaUpdateExceptionPolicy.LOG_WITH_IGNORE.equals((Object)policy) || SchemaUpdateExceptionPolicy.ALERT_WITH_IGNORE.equals((Object)policy)) {
            LOG.warn("Ignore table {} schema change: {}.", (Object)tableName, (Object)tableChange);
            return false;
        }
        throw new UnsupportedOperationException(String.format("Unsupported table %s schema change: %s.", tableName, tableChange));
    }

    public static class Builder {
        private String format;
        private boolean sparkEngineEnable;
        private SchemaUpdateExceptionPolicy schemaUpdatePolicy;
        private String databasePattern;
        private String tablePattern;
        private boolean pkAutoGenerated;

        public Builder withFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder withSparkEngineEnable(boolean sparkEngineEnable) {
            this.sparkEngineEnable = sparkEngineEnable;
            return this;
        }

        public Builder withSchemaUpdatePolicy(SchemaUpdateExceptionPolicy schemaUpdatePolicy) {
            this.schemaUpdatePolicy = schemaUpdatePolicy;
            return this;
        }

        public Builder withDatabasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return this;
        }

        public Builder withTablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public Builder withPkAutoGenerated(boolean pkAutoGenerated) {
            this.pkAutoGenerated = pkAutoGenerated;
            return this;
        }

        public MultipleSinkOption build() {
            return new MultipleSinkOption(this.format, this.sparkEngineEnable, this.schemaUpdatePolicy, this.databasePattern, this.tablePattern, this.pkAutoGenerated);
        }
    }
}

