/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.dirty.sink.s3;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySinkFactory;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3DirtySink;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3Options;

public class S3DirtySinkFactory
implements DirtySinkFactory {
    private static final String IDENTIFIER = "s3";
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_ENDPOINT = ConfigOptions.key((String)"dirty.side-output.s3.endpoint").stringType().noDefaultValue().withDescription("The endpoint of s3");
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_REGION = ConfigOptions.key((String)"dirty.side-output.s3.region").stringType().noDefaultValue().withDescription("The region of s3");
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_BUCKET = ConfigOptions.key((String)"dirty.side-output.s3.bucket").stringType().noDefaultValue().withDescription("The bucket of s3");
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_KEY = ConfigOptions.key((String)"dirty.side-output.s3.key").stringType().noDefaultValue().withDescription("The key of s3");
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_ACCESS_KEY_ID = ConfigOptions.key((String)"dirty.side-output.s3.access-key-id").stringType().noDefaultValue().withDescription("The access key of s3");
    private static final ConfigOption<String> DIRTY_SIDE_OUTPUT_SECRET_KEY_ID = ConfigOptions.key((String)"dirty.side-output.s3.secret-key-id").stringType().noDefaultValue().withDescription("The secret key of s3");

    @Override
    public <T> DirtySink<T> createDirtySink(DynamicTableFactory.Context context) {
        Configuration config = Configuration.fromMap((Map)context.getCatalogTable().getOptions());
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)config);
        this.validate((ReadableConfig)config);
        return new S3DirtySink(this.getS3Options((ReadableConfig)config), context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType());
    }

    private void validate(ReadableConfig config) {
        String identifier = config.getOptional(Constants.DIRTY_IDENTIFIER).orElse(null);
        if (identifier == null || identifier.trim().length() == 0) {
            throw new ValidationException("The option 'dirty.identifier' is not allowed to be empty.");
        }
    }

    private S3Options getS3Options(ReadableConfig config) {
        S3Options.Builder builder = S3Options.builder().setEndpoint(config.getOptional(DIRTY_SIDE_OUTPUT_ENDPOINT).orElse(null)).setRegion(config.getOptional(DIRTY_SIDE_OUTPUT_REGION).orElse(null)).setBucket(config.getOptional(DIRTY_SIDE_OUTPUT_BUCKET).orElse(null)).setKey(config.getOptional(DIRTY_SIDE_OUTPUT_KEY).orElse(null)).setBatchSize((Integer)config.get(Constants.DIRTY_SIDE_OUTPUT_BATCH_SIZE)).setMaxRetries((Integer)config.get(Constants.DIRTY_SIDE_OUTPUT_RETRIES)).setBatchIntervalMs((Long)config.get(Constants.DIRTY_SIDE_OUTPUT_BATCH_INTERVAL)).setMaxBatchBytes((Long)config.get(Constants.DIRTY_SIDE_OUTPUT_BATCH_BYTES)).setFormat((String)config.get(Constants.DIRTY_SIDE_OUTPUT_FORMAT)).setIgnoreSideOutputErrors((Boolean)config.get(Constants.DIRTY_SIDE_OUTPUT_IGNORE_ERRORS)).setEnableDirtyLog((Boolean)config.get(Constants.DIRTY_SIDE_OUTPUT_LOG_ENABLE)).setFieldDelimiter((String)config.get(Constants.DIRTY_SIDE_OUTPUT_FIELD_DELIMITER)).setLineDelimiter((String)config.get(Constants.DIRTY_SIDE_OUTPUT_LINE_DELIMITER)).setAccessKeyId(config.getOptional(DIRTY_SIDE_OUTPUT_ACCESS_KEY_ID).orElse(null)).setSecretKeyId(config.getOptional(DIRTY_SIDE_OUTPUT_SECRET_KEY_ID).orElse(null));
        return builder.build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(DIRTY_SIDE_OUTPUT_ENDPOINT);
        options.add(DIRTY_SIDE_OUTPUT_REGION);
        options.add(DIRTY_SIDE_OUTPUT_BUCKET);
        options.add(DIRTY_SIDE_OUTPUT_KEY);
        options.add(Constants.DIRTY_IDENTIFIER);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(Constants.DIRTY_SIDE_OUTPUT_BATCH_SIZE);
        options.add(Constants.DIRTY_SIDE_OUTPUT_RETRIES);
        options.add(Constants.DIRTY_SIDE_OUTPUT_BATCH_INTERVAL);
        options.add(Constants.DIRTY_SIDE_OUTPUT_BATCH_BYTES);
        options.add(Constants.DIRTY_SIDE_OUTPUT_FORMAT);
        options.add(Constants.DIRTY_SIDE_OUTPUT_IGNORE_ERRORS);
        options.add(Constants.DIRTY_SIDE_OUTPUT_LOG_ENABLE);
        options.add(Constants.DIRTY_SIDE_OUTPUT_FIELD_DELIMITER);
        options.add(Constants.DIRTY_SIDE_OUTPUT_LINE_DELIMITER);
        options.add(DIRTY_SIDE_OUTPUT_ACCESS_KEY_ID);
        options.add(DIRTY_SIDE_OUTPUT_SECRET_KEY_ID);
        return options;
    }
}

