/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.manager;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.sort.cdc.postgres.connection.PostgreSQLJdbcConnectionProvider;
import org.apache.inlong.sort.cdc.postgres.table.PostgreSQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLQueryVisitor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQLQueryVisitor.class);
    private final PostgreSQLJdbcConnectionProvider jdbcConnProvider;

    public PostgreSQLQueryVisitor(PostgreSQLJdbcConnectionProvider jdbcConnProvider) {
        this.jdbcConnProvider = jdbcConnProvider;
    }

    public List<Map<String, Object>> getTableColumnsMetaData(String schema, String table) {
        try {
            String query = "SELECT ordinal_position, tab_columns.column_name, data_type, character_maximum_length,\nnumeric_precision, is_nullable, tab_constraints.constraint_type,\ncol_constraints.constraint_name,col_check_constraints.check_clause\nFROM information_schema.columns AS tab_columns\nLEFT OUTER JOIN\ninformation_schema.constraint_column_usage AS col_constraints\nON tab_columns.table_name = col_constraints.table_name AND\ntab_columns.column_name = col_constraints.column_name\nLEFT OUTER JOIN\ninformation_schema.table_constraints AS tab_constraints\nON tab_constraints.constraint_name = col_constraints.constraint_name\nLEFT OUTER JOIN\ninformation_schema.check_constraints AS col_check_constraints\nON col_check_constraints.constraint_name = tab_constraints.constraint_name\nWHERE tab_columns.table_schema = ? \nAND tab_columns.table_name = ? \nORDER BY ordinal_position";
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Executing query '%s'", query));
            }
            return this.executeQuery(query, schema, table);
        }
        catch (ClassNotFoundException se) {
            throw new IllegalArgumentException("Failed to find jdbc driver." + se.getMessage(), se);
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("Failed to get table schema info from StarRocks. " + se.getMessage(), se);
        }
    }

    public Map<String, PostgreSQLDataType> getFieldMapping(String schema, String table) {
        List<Map<String, Object>> columns = this.getTableColumnsMetaData(schema, table);
        LinkedHashMap<String, PostgreSQLDataType> mapping = new LinkedHashMap<String, PostgreSQLDataType>();
        for (Map<String, Object> column : columns) {
            mapping.put(column.get("COLUMN_NAME").toString(), PostgreSQLDataType.fromString(column.get("DATA_TYPE").toString()));
        }
        return mapping;
    }

    public String getPostgreSQLVersion() {
        String query = "select version() as ver;";
        try {
            List<Map<String, Object>> rows;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Executing query '%s'", "select version() as ver;"));
            }
            if ((rows = this.executeQuery("select version() as ver;", new String[0])).isEmpty()) {
                return "";
            }
            String version = rows.get(0).get("ver").toString();
            LOG.info(String.format("PostgreSQL version: [%s].", version));
            return version;
        }
        catch (ClassNotFoundException se) {
            throw new IllegalArgumentException("Failed to find jdbc driver." + se.getMessage(), se);
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("Failed to get PostgreSQL version. " + se.getMessage(), se);
        }
    }

    private List<Map<String, Object>> executeQuery(String query, String ... args) throws ClassNotFoundException, SQLException {
        PreparedStatement stmt = this.jdbcConnProvider.getConnection().prepareStatement(query, 1004, 1007);
        for (int i = 0; i < args.length; ++i) {
            stmt.setString(i + 1, args[i]);
        }
        ResultSet rs = stmt.executeQuery();
        rs.next();
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int currRowIndex = rs.getRow();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                row.put(meta.getColumnName(i), rs.getObject(i));
            }
            list.add(row);
        }
        rs.absolute(currRowIndex);
        rs.close();
        this.jdbcConnProvider.close();
        return list;
    }

    public Long getQueryCount(String sql) {
        Long count = 0L;
        try {
            List<Map<String, Object>> data;
            Object opCount;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Executing query '%s'", sql));
            }
            if (null == (opCount = (data = this.executeQuery(sql, new String[0])).get(0).values().stream().findFirst().orElse(null))) {
                throw new RuntimeException("Faild to get data count from PostgreSQL. ");
            }
            count = opCount;
        }
        catch (ClassNotFoundException se) {
            throw new IllegalArgumentException("Failed to find jdbc driver." + se.getMessage(), se);
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("Failed to get data count from PostgreSQL. " + se.getMessage(), se);
        }
        return count;
    }
}

