/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.debezium.internal;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.internal.DebeziumOffset;
import com.ververica.cdc.debezium.internal.DebeziumOffsetSerializer;
import com.ververica.cdc.debezium.internal.Handover;
import io.debezium.connector.SnapshotRecord;
import io.debezium.data.Envelope;
import io.debezium.engine.ChangeEvent;
import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.cdc.postgres.connection.PostgreSQLJdbcConnectionOptions;
import org.apache.inlong.sort.cdc.postgres.connection.PostgreSQLJdbcConnectionProvider;
import org.apache.inlong.sort.cdc.postgres.debezium.internal.ColumnImpl;
import org.apache.inlong.sort.cdc.postgres.debezium.internal.TableImpl;
import org.apache.inlong.sort.cdc.postgres.manager.PostgreSQLQueryVisitor;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.util.RecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DebeziumChangeFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumChangeFetcher.class);
    private final SourceFunction.SourceContext<T> sourceContext;
    private final Object checkpointLock;
    private final DebeziumDeserializationSchema<T> deserialization;
    private final DebeziumCollector debeziumCollector;
    private final DebeziumOffset debeziumOffset;
    private final DebeziumOffsetSerializer stateSerializer;
    private final String heartbeatTopicPrefix;
    private final Handover handover;
    private boolean isInDbSnapshotPhase;
    private volatile boolean isRunning = true;
    private volatile long messageTimestamp = 0L;
    private volatile long processTime = 0L;
    private volatile long fetchDelay = 0L;
    private volatile long emitDelay = 0L;
    private Properties properties;
    private PostgreSQLQueryVisitor postgreSQLQueryVisitor;
    private Map<String, TableChangeHolder> tableChangeMap = new ConcurrentHashMap<String, TableChangeHolder>();
    private static final long DDL_UPDATE_INTERVAL = 2000L;

    public DebeziumChangeFetcher(SourceFunction.SourceContext<T> sourceContext, DebeziumDeserializationSchema<T> deserialization, Properties properties, boolean isInDbSnapshotPhase, String heartbeatTopicPrefix, Handover handover) {
        this.sourceContext = sourceContext;
        this.checkpointLock = sourceContext.getCheckpointLock();
        this.deserialization = deserialization;
        this.properties = properties;
        this.isInDbSnapshotPhase = isInDbSnapshotPhase;
        this.heartbeatTopicPrefix = heartbeatTopicPrefix;
        this.debeziumCollector = new DebeziumCollector();
        this.debeziumOffset = new DebeziumOffset();
        this.stateSerializer = DebeziumOffsetSerializer.INSTANCE;
        this.handover = handover;
        String url = String.format("jdbc:postgresql://%s:%s/%s", properties.getProperty("database.hostname"), properties.getProperty("database.port"), properties.getProperty("database.dbname"));
        PostgreSQLJdbcConnectionOptions jdbcConnectionOptions = new PostgreSQLJdbcConnectionOptions(url, properties.getProperty("database.user"), properties.getProperty("database.password"));
        this.postgreSQLQueryVisitor = new PostgreSQLQueryVisitor(new PostgreSQLJdbcConnectionProvider(jdbcConnectionOptions));
    }

    public byte[] snapshotCurrentState() throws Exception {
        assert (Thread.holdsLock(this.checkpointLock));
        if (this.debeziumOffset.sourceOffset == null || this.debeziumOffset.sourcePartition == null) {
            return null;
        }
        return this.stateSerializer.serialize(this.debeziumOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFetchLoop() throws Exception {
        try {
            if (this.isInDbSnapshotPhase) {
                List<ChangeEvent<SourceRecord, SourceRecord>> events = this.handover.pollNext();
                Object object = this.checkpointLock;
                synchronized (object) {
                    LOG.info("Database snapshot phase can't perform checkpoint, acquired Checkpoint lock.");
                    this.handleBatch(events);
                    while (this.isRunning && this.isInDbSnapshotPhase) {
                        this.handleBatch(this.handover.pollNext());
                    }
                }
                LOG.info("Received record from streaming binlog phase, released checkpoint lock.");
            }
            while (this.isRunning) {
                this.handleBatch(this.handover.pollNext());
            }
        }
        catch (Handover.ClosedException closedException) {
            // empty catch block
        }
    }

    public void close() {
        this.isRunning = false;
        this.handover.close();
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public long getEmitDelay() {
        return this.emitDelay;
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.processTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBatch(List<ChangeEvent<SourceRecord, SourceRecord>> changeEvents) throws Exception {
        if (CollectionUtils.isEmpty(changeEvents)) {
            return;
        }
        this.processTime = System.currentTimeMillis();
        for (ChangeEvent<SourceRecord, SourceRecord> event : changeEvents) {
            SourceRecord record = event.value();
            this.updateMessageTimestamp(record);
            long l = this.fetchDelay = this.isInDbSnapshotPhase ? 0L : this.processTime - this.messageTimestamp;
            if (this.isHeartbeatEvent(record)) {
                Object object = this.checkpointLock;
                synchronized (object) {
                    this.debeziumOffset.setSourcePartition(record.sourcePartition());
                    this.debeziumOffset.setSourceOffset(record.sourceOffset());
                    continue;
                }
            }
            this.deserialization.deserialize(record, this.debeziumCollector, this.getTableChange(record));
            if (!this.isSnapshotRecord(record)) {
                LOG.debug("Snapshot phase finishes.");
                this.isInDbSnapshotPhase = false;
            }
            this.emitRecordsUnderCheckpointLock(this.debeziumCollector.records, record.sourcePartition(), record.sourceOffset());
        }
    }

    private TableChanges.TableChange getTableChange(SourceRecord record) throws Exception {
        TableChanges.TableChange tableChange;
        Envelope.Operation op = Envelope.operationFor(record);
        Schema valueSchema = op == Envelope.Operation.DELETE ? record.valueSchema().field("before").schema() : record.valueSchema().field("after").schema();
        List<Field> fields = valueSchema.fields();
        TableId tableId = RecordUtils.getTableId(record);
        String schema = tableId.schema();
        String table = tableId.table();
        String id = tableId.identifier();
        if (!this.tableChangeMap.containsKey(id)) {
            List<Map<String, Object>> columns = this.postgreSQLQueryVisitor.getTableColumnsMetaData(schema, table);
            LOG.info("columns: {}", columns);
            tableChange = this.initTableChange(tableId, TableChanges.TableChangeType.CREATE, columns);
            TableChangeHolder holder = new TableChangeHolder();
            holder.tableChange = tableChange;
            holder.timestamp = System.currentTimeMillis();
            this.tableChangeMap.put(id, holder);
        } else {
            TableChangeHolder holder = this.tableChangeMap.get(id);
            tableChange = holder.tableChange;
            if (System.currentTimeMillis() - holder.timestamp > 2000L && holder.tableChange.getTable() instanceof TableImpl) {
                TableImpl tableImpl = (TableImpl)holder.tableChange.getTable();
                List<Column> columnList = tableImpl.columns();
                if (columnList.size() != fields.size()) {
                    List<Map<String, Object>> columns = this.postgreSQLQueryVisitor.getTableColumnsMetaData(schema, table);
                    LOG.info("columns: {}", columns);
                    holder.tableChange = tableChange = this.initTableChange(tableId, TableChanges.TableChangeType.CREATE, columns);
                }
                holder.timestamp = System.currentTimeMillis();
                this.tableChangeMap.put(id, holder);
            }
        }
        return tableChange;
    }

    private TableChanges.TableChange initTableChange(TableId tableId, TableChanges.TableChangeType type, List<Map<String, Object>> columns) {
        ArrayList<Column> sortedColumns = new ArrayList<Column>();
        ArrayList<String> pkColumnNames = new ArrayList<String>();
        String defaultCharsetName = "utf-8";
        for (Map<String, Object> column : columns) {
            int jdbcType;
            int columnLength = -1;
            Integer characterMaxLen = (Integer)column.get("character_maximum_length");
            if (characterMaxLen != null) {
                columnLength = characterMaxLen;
            }
            Integer columnScale = -1;
            Integer numPrecision = (Integer)column.get("numeric_precision");
            if (numPrecision != null) {
                columnScale = numPrecision;
            }
            boolean optional = "YES".equals(column.get("is_nullable"));
            boolean autoIncremented = false;
            boolean generated = false;
            String columnName = (String)column.get("column_name");
            String constraintType = (String)column.get("constraint_type");
            if (constraintType != null && constraintType.equalsIgnoreCase("PRIMARY KEY")) {
                pkColumnNames.add(columnName);
            }
            int position = (Integer)column.get("ordinal_position");
            String typeName = (String)column.get("data_type");
            int componentType = jdbcType = this.getJdbcType(typeName);
            String charsetName = "utf-8";
            ColumnImpl columnImpl = new ColumnImpl(columnName, position, jdbcType, componentType, typeName, null, charsetName, defaultCharsetName, columnLength, columnScale, optional, autoIncremented, generated);
            sortedColumns.add(columnImpl);
        }
        TableImpl tableImpl = new TableImpl(tableId, sortedColumns, pkColumnNames, defaultCharsetName);
        return new TableChanges.TableChange(type, tableImpl);
    }

    private int getJdbcType(String dataType) {
        switch (dataType) {
            case "integer": {
                return 4;
            }
            case "timestamp without time zone": 
            case "timestamp with time zone": {
                return 93;
            }
            case "smallint": {
                return 5;
            }
            case "boolean": {
                return 16;
            }
            case "text": {
                return -16;
            }
            case "numeric": {
                return 2;
            }
            case "bigint": {
                return -5;
            }
            case "double precision": {
                return 8;
            }
            case "\"char\"": {
                return 1;
            }
            case "real": {
                return 7;
            }
        }
        return 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitRecordsUnderCheckpointLock(Queue<T> records, Map<String, ?> sourcePartition, Map<String, ?> sourceOffset) {
        Object object = this.checkpointLock;
        synchronized (object) {
            T record;
            while ((record = records.poll()) != null) {
                this.emitDelay = this.isInDbSnapshotPhase ? 0L : System.currentTimeMillis() - this.messageTimestamp;
                this.sourceContext.collect(record);
            }
            this.debeziumOffset.setSourcePartition(sourcePartition);
            this.debeziumOffset.setSourceOffset(sourceOffset);
        }
    }

    private void updateMessageTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("source") == null) {
            return;
        }
        Struct source = value.getStruct("source");
        if (source.schema().field("ts_ms") == null) {
            return;
        }
        Long tsMs = source.getInt64("ts_ms");
        if (tsMs != null) {
            this.messageTimestamp = tsMs;
        }
    }

    private boolean isHeartbeatEvent(SourceRecord record) {
        String topic = record.topic();
        return topic != null && topic.startsWith(this.heartbeatTopicPrefix);
    }

    private boolean isSnapshotRecord(SourceRecord record) {
        Struct value = (Struct)record.value();
        if (value != null) {
            Struct source = value.getStruct("source");
            SnapshotRecord snapshotRecord = SnapshotRecord.fromSource(source);
            return SnapshotRecord.TRUE == snapshotRecord;
        }
        return false;
    }

    private class TableChangeHolder {
        public TableChanges.TableChange tableChange;
        public long timestamp;

        private TableChangeHolder() {
        }
    }

    private class DebeziumCollector
    implements Collector<T> {
        private final Queue<T> records = new ArrayDeque();

        private DebeziumCollector() {
        }

        public void collect(T record) {
            this.records.add(record);
        }

        public void close() {
        }
    }
}

