/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.debezium.internal;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ColumnImpl
implements Column,
Comparable<Column> {
    private final String name;
    private final int position;
    private final int jdbcType;
    private final int nativeType;
    private final String typeName;
    private final String typeExpression;
    private final String charsetName;
    private final int length;
    private final Integer scale;
    private final boolean optional;
    private final boolean autoIncremented;
    private final boolean generated;
    private final Object defaultValue;
    private final boolean hasDefaultValue;
    private final List<String> enumValues;

    protected ColumnImpl(String columnName, int position, int jdbcType, int componentType, String typeName, String typeExpression, String charsetName, String defaultCharsetName, int columnLength, Integer columnScale, boolean optional, boolean autoIncremented, boolean generated) {
        this(columnName, position, jdbcType, componentType, typeName, typeExpression, charsetName, defaultCharsetName, columnLength, columnScale, null, optional, autoIncremented, generated, null, false);
    }

    protected ColumnImpl(String columnName, int position, int jdbcType, int nativeType, String typeName, String typeExpression, String charsetName, String defaultCharsetName, int columnLength, Integer columnScale, boolean optional, boolean autoIncremented, boolean generated, Object defaultValue, boolean hasDefaultValue) {
        this(columnName, position, jdbcType, nativeType, typeName, typeExpression, charsetName, defaultCharsetName, columnLength, columnScale, null, optional, autoIncremented, generated, defaultValue, hasDefaultValue);
    }

    protected ColumnImpl(String columnName, int position, int jdbcType, int nativeType, String typeName, String typeExpression, String charsetName, String defaultCharsetName, int columnLength, Integer columnScale, List<String> enumValues, boolean optional, boolean autoIncremented, boolean generated, Object defaultValue, boolean hasDefaultValue) {
        this.name = columnName;
        this.position = position;
        this.jdbcType = jdbcType;
        this.nativeType = nativeType;
        this.typeName = typeName;
        this.typeExpression = typeExpression;
        if (this.typeUsesCharset() && (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName))) {
            charsetName = defaultCharsetName;
        }
        this.charsetName = charsetName;
        this.length = columnLength;
        this.scale = columnScale;
        this.optional = optional;
        this.autoIncremented = autoIncremented;
        this.generated = generated;
        this.defaultValue = defaultValue;
        this.hasDefaultValue = hasDefaultValue;
        ArrayList arrayList = this.enumValues = enumValues == null ? new ArrayList() : enumValues;
        assert (this.length >= -1);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int jdbcType() {
        return this.jdbcType;
    }

    @Override
    public int nativeType() {
        return this.nativeType;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public String typeExpression() {
        return this.typeExpression;
    }

    @Override
    public String charsetName() {
        return this.charsetName;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Optional<Integer> scale() {
        return Optional.ofNullable(this.scale);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public List<String> enumValues() {
        return this.enumValues;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            return this.name().equalsIgnoreCase(that.name()) && this.typeExpression().equalsIgnoreCase(that.typeExpression()) && this.typeName().equalsIgnoreCase(that.typeName()) && this.jdbcType() == that.jdbcType() && Strings.equalsIgnoreCase(this.charsetName(), that.charsetName()) && this.position() == that.position() && this.length() == that.length() && this.scale().equals(that.scale()) && this.isOptional() == that.isOptional() && this.isAutoIncremented() == that.isAutoIncremented() && this.isGenerated() == that.isGenerated() && Objects.equals(this.defaultValue(), that.defaultValue()) && this.hasDefaultValue() == that.hasDefaultValue() && this.enumValues().equals(that.enumValues());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" ").append(this.typeName);
        if (this.length >= 0) {
            sb.append('(').append(this.length);
            if (this.scale != null) {
                sb.append(", ").append(this.scale);
            }
            sb.append(')');
        }
        if (this.charsetName != null && !this.charsetName.isEmpty()) {
            sb.append(" CHARSET ").append(this.charsetName);
        }
        if (!this.optional) {
            sb.append(" NOT NULL");
        }
        if (this.autoIncremented) {
            sb.append(" AUTO_INCREMENTED");
        }
        if (this.generated) {
            sb.append(" GENERATED");
        }
        if (this.hasDefaultValue() && this.defaultValue() == null) {
            sb.append(" DEFAULT VALUE NULL");
        } else if (this.defaultValue != null) {
            sb.append(" DEFAULT VALUE ").append(this.defaultValue);
        }
        return sb.toString();
    }

    @Override
    public ColumnEditor edit() {
        ColumnEditor editor = Column.editor().name(this.name()).type(this.typeName(), this.typeExpression()).jdbcType(this.jdbcType()).nativeType(this.nativeType).charsetName(this.charsetName).length(this.length()).scale(this.scale().orElse(null)).position(this.position()).optional(this.isOptional()).autoIncremented(this.isAutoIncremented()).generated(this.isGenerated()).enumValues(this.enumValues);
        if (this.hasDefaultValue()) {
            editor.defaultValue(this.defaultValue());
        }
        return editor;
    }
}

