/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.inlong.sort.cdc.postgres.connection.PostgreSQLJdbcConnectionIProvider;
import org.apache.inlong.sort.cdc.postgres.connection.PostgreSQLJdbcConnectionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLJdbcConnectionProvider
implements PostgreSQLJdbcConnectionIProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQLJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final PostgreSQLJdbcConnectionOptions jdbcOptions;
    private volatile transient Connection connection;

    public PostgreSQLJdbcConnectionProvider(PostgreSQLJdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.connection == null) {
            PostgreSQLJdbcConnectionProvider postgreSQLJdbcConnectionProvider = this;
            synchronized (postgreSQLJdbcConnectionProvider) {
                if (this.connection == null) {
                    Class.forName(this.jdbcOptions.getDriverName());
                    this.connection = this.jdbcOptions.getUsername().isPresent() ? DriverManager.getConnection(this.jdbcOptions.getDbURL(), this.jdbcOptions.getUsername().orElse(null), this.jdbcOptions.getPassword().orElse(null)) : DriverManager.getConnection(this.jdbcOptions.getDbURL());
                }
            }
        }
        return this.connection;
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.close();
        this.connection = this.getConnection();
        return this.connection;
    }

    @Override
    public void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.error("JDBC connection close failed.", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }
}

