/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres.connection;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class PostgreSQLJdbcConnectionOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String url;
    protected final String driverName;
    @Nullable
    protected final String username;
    @Nullable
    protected final String password;

    public PostgreSQLJdbcConnectionOptions(String url, String username, String password) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (String)"jdbc url is empty");
        this.driverName = "org.postgresql.Driver";
        this.username = username;
        this.password = password;
    }

    public String getDbURL() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }
}

