/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.postgres;

import com.ververica.cdc.debezium.Validator;
import io.debezium.connector.postgresql.PostgresConnector;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.postgres.DebeziumSourceFunction;
import org.apache.inlong.sort.cdc.postgres.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;

public class PostgreSQLSource {
    private static final long DEFAULT_HEARTBEAT_MS = Duration.ofMinutes(5L).toMillis();

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private String pluginName = "decoderbufs";
        private String slotName = "flink";
        private int port = 5432;
        private String hostname;
        private String database;
        private String username;
        private String password;
        private String[] schemaList;
        private String[] tableList;
        private Properties dbzProperties;
        private DebeziumDeserializationSchema<T> deserializer;
        private String inlongMetric;
        private String inlongAudit;
        private boolean migrateAll = false;

        public Builder<T> decodingPluginName(String name) {
            this.pluginName = name;
            return this;
        }

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> database(String database) {
            this.database = database;
            return this;
        }

        public Builder<T> schemaList(String ... schemaList) {
            this.schemaList = schemaList;
            return this;
        }

        public Builder<T> tableList(String ... tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> inlongMetric(String inlongMetric) {
            this.inlongMetric = inlongMetric;
            return this;
        }

        public Builder<T> inlongAudit(String inlongAudit) {
            this.inlongAudit = inlongAudit;
            return this;
        }

        public Builder<T> migrateAll(boolean migrateAll) {
            this.migrateAll = migrateAll;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", PostgresConnector.class.getCanonicalName());
            props.setProperty("plugin.name", this.pluginName);
            props.setProperty("database.server.name", "postgres_cdc_source");
            props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
            props.setProperty("database.dbname", (String)Preconditions.checkNotNull((Object)this.database));
            props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
            props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
            props.setProperty("database.port", String.valueOf(this.port));
            props.setProperty("slot.name", this.slotName);
            props.setProperty("heartbeat.interval.ms", String.valueOf(DEFAULT_HEARTBEAT_MS));
            if (this.schemaList != null) {
                props.setProperty("schema.whitelist", String.join((CharSequence)",", this.schemaList));
            }
            if (this.tableList != null) {
                props.setProperty("table.whitelist", String.join((CharSequence)",", this.tableList));
            }
            if (this.dbzProperties != null) {
                props.putAll((Map<?, ?>)this.dbzProperties);
            }
            return new DebeziumSourceFunction<T>(this.deserializer, props, null, Validator.getDefaultValidator(), this.inlongMetric, this.inlongAudit, this.migrateAll);
        }
    }
}

