/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.postgresql.Filters;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ServerInfo;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PostgresSchema
extends RelationalDatabaseSchema {
    protected static final String PUBLIC_SCHEMA_NAME = "public";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSchema.class);
    private final TypeRegistry typeRegistry;
    private final Map<TableId, List<String>> tableIdToToastableColumns;
    private final Map<Integer, TableId> relationIdToTableId;
    private final boolean readToastableColumns;

    protected PostgresSchema(PostgresConnectorConfig config, TypeRegistry typeRegistry, Charset databaseCharset, TopicSelector<TableId> topicSelector) {
        super(config, topicSelector, new Filters(config).tableFilter(), config.getColumnFilter(), PostgresSchema.getTableSchemaBuilder(config, typeRegistry, databaseCharset), false, config.getKeyMapper());
        this.typeRegistry = typeRegistry;
        this.tableIdToToastableColumns = new HashMap<TableId, List<String>>();
        this.relationIdToTableId = new HashMap<Integer, TableId>();
        this.readToastableColumns = config.skipRefreshSchemaOnMissingToastableData();
    }

    private static TableSchemaBuilder getTableSchemaBuilder(PostgresConnectorConfig config, TypeRegistry typeRegistry, Charset databaseCharset) {
        PostgresValueConverter valueConverter = new PostgresValueConverter(databaseCharset, config.getDecimalMode(), config.getTemporalPrecisionMode(), ZoneOffset.UTC, null, config.includeUnknownDatatypes(), typeRegistry, config.hStoreHandlingMode(), config.binaryHandlingMode(), config.intervalHandlingMode(), config.toastedValuePlaceholder());
        return new TableSchemaBuilder(valueConverter, SchemaNameAdjuster.create(), config.customConverterRegistry(), config.getSourceInfoStructMaker().schema(), config.getSanitizeFieldNames());
    }

    protected PostgresSchema refresh(PostgresConnection connection, boolean printReplicaIdentityInfo) throws SQLException {
        connection.readSchema(this.tables(), null, null, this.getTableFilter(), null, true);
        if (printReplicaIdentityInfo) {
            this.tableIds().forEach(tableId -> this.printReplicaIdentityInfo(connection, (TableId)tableId));
        }
        this.refreshSchemas();
        if (this.readToastableColumns) {
            this.tableIds().forEach(tableId -> this.refreshToastableColumnsMap(connection, (TableId)tableId));
        }
        return this;
    }

    private void printReplicaIdentityInfo(PostgresConnection connection, TableId tableId) {
        try {
            ServerInfo.ReplicaIdentity replicaIdentity = connection.readReplicaIdentityInfo(tableId);
            LOGGER.info("REPLICA IDENTITY for '{}' is '{}'; {}", new Object[]{tableId, replicaIdentity, replicaIdentity.description()});
        }
        catch (SQLException e) {
            LOGGER.warn("Cannot determine REPLICA IDENTITY info for '{}'", (Object)tableId);
        }
    }

    protected void refresh(PostgresConnection connection, TableId tableId, boolean refreshToastableColumns) throws SQLException {
        Tables temp = new Tables();
        connection.readSchema(temp, null, null, tableId::equals, null, true);
        if (temp.size() == 0) {
            LOGGER.warn("Refresh of {} was requested but the table no longer exists", (Object)tableId);
            return;
        }
        this.tables().overwriteTable(temp.forTable(tableId));
        this.refreshSchema(tableId);
        if (refreshToastableColumns) {
            this.refreshToastableColumnsMap(connection, tableId);
        }
    }

    protected boolean isFilteredOut(TableId id) {
        return !this.getTableFilter().isIncluded(id);
    }

    protected void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(this::refreshSchema);
    }

    private void refreshToastableColumnsMap(PostgresConnection connection, TableId tableId) {
        ArrayList toastableColumns = new ArrayList();
        String relName = tableId.table();
        String schema = tableId.schema() != null && tableId.schema().length() > 0 ? tableId.schema() : PUBLIC_SCHEMA_NAME;
        String statement = "select att.attname from pg_attribute att  join pg_class tbl on tbl.oid = att.attrelid join pg_namespace ns on tbl.relnamespace = ns.oid where tbl.relname = ? and ns.nspname = ? and att.attnum > 0 and att.attstorage in ('x', 'e', 'm') and not att.attisdropped;";
        try {
            connection.prepareQuery(statement, stmt -> {
                stmt.setString(1, relName);
                stmt.setString(2, schema);
            }, rs -> {
                while (rs.next()) {
                    toastableColumns.add(rs.getString(1));
                }
            });
            if (!connection.connection().getAutoCommit()) {
                connection.connection().commit();
            }
        }
        catch (SQLException e) {
            throw new ConnectException("Unable to refresh toastable columns mapping", e);
        }
        this.tableIdToToastableColumns.put(tableId, Collections.unmodifiableList(toastableColumns));
    }

    protected static TableId parse(String table) {
        TableId tableId = TableId.parse(table, false);
        if (tableId == null) {
            return null;
        }
        return tableId.schema() == null ? new TableId(tableId.catalog(), PUBLIC_SCHEMA_NAME, tableId.table()) : tableId;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public List<String> getToastableColumnsForTableId(TableId tableId) {
        return this.tableIdToToastableColumns.getOrDefault(tableId, Collections.emptyList());
    }

    public void applySchemaChangesForTable(int relationId, Table table) {
        assert (table != null);
        if (this.isFilteredOut(table.id())) {
            LOGGER.trace("Skipping schema refresh for table '{}' with relation '{}' as table is filtered", (Object)table.id(), (Object)relationId);
            return;
        }
        this.relationIdToTableId.put(relationId, table.id());
        this.refresh(table);
    }

    public Table tableFor(int relationId) {
        TableId tableId = this.relationIdToTableId.get(relationId);
        if (tableId == null) {
            LOGGER.debug("Relation '{}' is unknown, cannot resolve to table", (Object)relationId);
            return null;
        }
        LOGGER.debug("Relation '{}' resolved to table '{}'", (Object)relationId, (Object)tableId);
        return this.tableFor(tableId);
    }

    @Override
    public boolean tableInformationComplete() {
        return false;
    }
}

