/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.dirty;

import java.io.Serializable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.inlong.sort.base.Constants;

public class DirtyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean ignoreDirty;
    private final boolean enableDirtySideOutput;
    private final boolean ignoreSideOutputErrors;
    private final String dirtyConnector;
    private final String labels;
    private final String logTag;
    private final String identifier;

    private DirtyOptions(boolean ignoreDirty, boolean enableDirtySideOutput, boolean ignoreSideOutputErrors, String dirtyConnector, String labels, String logTag, String identifier) {
        this.ignoreDirty = ignoreDirty;
        this.enableDirtySideOutput = enableDirtySideOutput;
        this.ignoreSideOutputErrors = ignoreSideOutputErrors;
        this.dirtyConnector = dirtyConnector;
        this.labels = labels;
        this.logTag = logTag;
        this.identifier = identifier;
    }

    public static DirtyOptions fromConfig(ReadableConfig config) {
        boolean ignoreDirty = (Boolean)config.get(Constants.DIRTY_IGNORE);
        boolean enableDirtySink = (Boolean)config.get(Constants.DIRTY_SIDE_OUTPUT_ENABLE);
        boolean ignoreSinkError = (Boolean)config.get(Constants.DIRTY_SIDE_OUTPUT_IGNORE_ERRORS);
        String dirtyConnector = config.getOptional(Constants.DIRTY_SIDE_OUTPUT_CONNECTOR).orElse(null);
        String labels = config.getOptional(Constants.DIRTY_SIDE_OUTPUT_LABELS).orElse(null);
        String logTag = (String)config.get(Constants.DIRTY_SIDE_OUTPUT_LOG_TAG);
        String identifier = (String)config.get(Constants.DIRTY_IDENTIFIER);
        return new DirtyOptions(ignoreDirty, enableDirtySink, ignoreSinkError, dirtyConnector, labels, logTag, identifier);
    }

    public void validate() {
        if (!this.ignoreDirty || !this.enableDirtySideOutput) {
            return;
        }
        if (this.dirtyConnector == null || this.dirtyConnector.trim().length() == 0) {
            throw new ValidationException("The option 'dirty.side-output.connector' is not allowed to be empty when the option 'dirty.ignore' is 'true' and the option 'dirty.side-output.enable' is 'true'");
        }
    }

    public boolean ignoreDirty() {
        return this.ignoreDirty;
    }

    public String getDirtyConnector() {
        return this.dirtyConnector;
    }

    public String getLabels() {
        return this.labels;
    }

    public String getLogTag() {
        return this.logTag;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean ignoreSideOutputErrors() {
        return this.ignoreSideOutputErrors;
    }

    public boolean enableDirtySideOutput() {
        return this.enableDirtySideOutput;
    }
}

