/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskController;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.PayloadGenerator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.RoundTripWorker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.TopicsSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.UniformRandomPayloadGenerator;
import java.util.Collections;
import java.util.Map;

public class RoundTripWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final PayloadGenerator valueGenerator;
    private final TopicsSpec activeTopics;
    private final long maxMessages;
    private final Map<String, String> commonClientConf;
    private final Map<String, String> producerConf;
    private final Map<String, String> consumerConf;
    private final Map<String, String> adminClientConf;

    @JsonCreator
    public RoundTripWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="consumerConf") Map<String, String> consumerConf, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="valueGenerator") PayloadGenerator valueGenerator, @JsonProperty(value="activeTopics") TopicsSpec activeTopics, @JsonProperty(value="maxMessages") long maxMessages) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.valueGenerator = valueGenerator == null ? new UniformRandomPayloadGenerator(32, 123L, 10) : valueGenerator;
        this.activeTopics = activeTopics == null ? TopicsSpec.EMPTY : activeTopics.immutableCopy();
        this.maxMessages = maxMessages;
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
        this.adminClientConf = this.configOrEmptyMap(adminClientConf);
        this.producerConf = this.configOrEmptyMap(producerConf);
        this.consumerConf = this.configOrEmptyMap(consumerConf);
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public TopicsSpec activeTopics() {
        return this.activeTopics;
    }

    @JsonProperty
    public PayloadGenerator valueGenerator() {
        return this.valueGenerator;
    }

    @JsonProperty
    public long maxMessages() {
        return this.maxMessages;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public Map<String, String> consumerConf() {
        return this.consumerConf;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new RoundTripWorker(id, this);
    }
}

