/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.VoteRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.VoteResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.VoteResponse;
import java.util.Collections;

public class VoteRequest
extends AbstractRequest {
    public final VoteRequestData data;

    private VoteRequest(VoteRequestData data, short version) {
        super(ApiKeys.VOTE, version);
        this.data = data;
    }

    public VoteRequest(Struct struct, short version) {
        super(ApiKeys.VOTE, version);
        this.data = new VoteRequestData(struct, version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new VoteResponse(new VoteResponseData().setErrorCode(Errors.forException(e).code()));
    }

    public static VoteRequestData singletonRequest(TopicPartition topicPartition, int candidateEpoch, int candidateId, int lastEpoch, long lastEpochEndOffset) {
        return VoteRequest.singletonRequest(topicPartition, null, candidateEpoch, candidateId, lastEpoch, lastEpochEndOffset);
    }

    public static VoteRequestData singletonRequest(TopicPartition topicPartition, String clusterId, int candidateEpoch, int candidateId, int lastEpoch, long lastEpochEndOffset) {
        return new VoteRequestData().setClusterId(clusterId).setTopics(Collections.singletonList(new VoteRequestData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new VoteRequestData.PartitionData().setPartitionIndex(topicPartition.partition()).setCandidateEpoch(candidateEpoch).setCandidateId(candidateId).setLastOffsetEpoch(lastEpoch).setLastOffset(lastEpochEndOffset)))));
    }

    public static class Builder
    extends AbstractRequest.Builder<VoteRequest> {
        private final VoteRequestData data;

        public Builder(VoteRequestData data) {
            super(ApiKeys.VOTE);
            this.data = data;
        }

        @Override
        public VoteRequest build(short version) {
            return new VoteRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

