/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class DeleteTopicsResponseData
implements ApiMessage {
    int throttleTimeMs;
    DeletableTopicResultCollection responses;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public DeleteTopicsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteTopicsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DeleteTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.responses = new DeletableTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 20;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        DeletableTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            newCollection = new DeletableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableTopicResult(_readable, _version));
            }
            this.responses = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            newCollection = new DeletableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeletableTopicResult(_readable, _version));
            }
            this.responses = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.responses.size() + 1);
            for (DeletableTopicResult responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.responses.size());
            for (DeletableTopicResult responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = _version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("responses");
        this.responses = new DeletableTopicResultCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.responses.add(new DeletableTopicResult((Struct)nestedObject, _version));
        }
        if (_version >= 4 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 4) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.responses.size()];
        int i = 0;
        for (DeletableTopicResult element : this.responses) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("responses", (Object)_nestedObjects);
        if (_version >= 4) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize = _version >= 4 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.responses.size() + 1)) : (_arraySize += 4);
        for (DeletableTopicResult responsesElement : this.responses) {
            _arraySize += responsesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 4) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteTopicsResponseData)) {
            return false;
        }
        DeleteTopicsResponseData other = (DeleteTopicsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        return hashCode;
    }

    @Override
    public DeleteTopicsResponseData duplicate() {
        DeleteTopicsResponseData _duplicate = new DeleteTopicsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        DeletableTopicResultCollection newResponses = new DeletableTopicResultCollection(this.responses.size());
        for (DeletableTopicResult _element : this.responses) {
            newResponses.add(_element.duplicate());
        }
        _duplicate.responses = newResponses;
        return _duplicate;
    }

    public String toString() {
        return "DeleteTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", responses=" + MessageUtil.deepToString(this.responses.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public DeletableTopicResultCollection responses() {
        return this.responses;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteTopicsResponseData setResponses(DeletableTopicResultCollection v) {
        this.responses = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new ArrayOf(DeletableTopicResult.SCHEMA_0), "The results for each topic we tried to delete.")));
        SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new CompactArrayOf(DeletableTopicResult.SCHEMA_4), "The results for each topic we tried to delete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", new CompactArrayOf(DeletableTopicResult.SCHEMA_5), "The results for each topic we tried to delete."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class DeletableTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<DeletableTopicResult> {
        public DeletableTopicResultCollection() {
        }

        public DeletableTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public DeletableTopicResultCollection(Iterator<DeletableTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public DeletableTopicResult find(String name) {
            DeletableTopicResult _key = new DeletableTopicResult();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<DeletableTopicResult> findAll(String name) {
            DeletableTopicResult _key = new DeletableTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public DeletableTopicResultCollection duplicate() {
            DeletableTopicResultCollection _duplicate = new DeletableTopicResultCollection(this.size());
            for (DeletableTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class DeletableTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public DeletableTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeletableTopicResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
            this.prev = -2;
            this.next = -2;
        }

        public DeletableTopicResult() {
            this.name = "";
            this.errorCode = 0;
            this.errorMessage = null;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeletableTopicResult");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.errorCode = _readable.readShort();
            if (_version >= 5) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString(length);
                }
            } else {
                this.errorMessage = null;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.errorCode);
            if (_version >= 5) {
                if (this.errorMessage == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _stringBytes = _cache.getSerializedValue(this.errorMessage);
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    _writable.writeByteArray(_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeletableTopicResult");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = _version >= 5 ? struct.getString("error_message") : null;
            if (_version >= 4 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeletableTopicResult");
            }
            TreeMap _taggedFields = null;
            if (_version >= 4) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("error_code", (Object)this.errorCode);
            if (_version >= 5) {
                struct.set("error_message", (Object)this.errorMessage);
            }
            if (_version >= 4) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeletableTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 4 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 2;
            if (_version >= 5) {
                if (this.errorMessage == null) {
                    ++_size;
                } else {
                    _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                    _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 4) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof DeletableTopicResult)) {
                return false;
            }
            DeletableTopicResult other = (DeletableTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeletableTopicResult)) {
                return false;
            }
            DeletableTopicResult other = (DeletableTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public DeletableTopicResult duplicate() {
            DeletableTopicResult _duplicate = new DeletableTopicResult();
            _duplicate.name = this.name;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "DeletableTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeletableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public DeletableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeletableTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."))));
            SCHEMA_4 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("error_code", Type.INT16, "The deletion error, or 0 if the deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

