/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin;

public enum ScramMechanism {
    UNKNOWN(0),
    SCRAM_SHA_256(1),
    SCRAM_SHA_512(2);

    private final byte type;
    private final String mechanismName;

    public static ScramMechanism fromType(byte type) {
        for (ScramMechanism scramMechanism : ScramMechanism.values()) {
            if (scramMechanism.type != type) continue;
            return scramMechanism;
        }
        return UNKNOWN;
    }

    public static ScramMechanism fromMechanismName(String mechanismName) {
        ScramMechanism retvalFoundMechanism = ScramMechanism.valueOf(mechanismName.replace('-', '_'));
        return retvalFoundMechanism != null ? retvalFoundMechanism : UNKNOWN;
    }

    public String mechanismName() {
        return this.mechanismName;
    }

    public byte type() {
        return this.type;
    }

    private ScramMechanism(byte type) {
        this.type = type;
        this.mechanismName = this.toString().replace('_', '-');
    }
}

