/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mongodb.table.filter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.mongodb.table.filter.MongoRowKind;

public class RowKindValidator
implements Serializable {
    private final Set<MongoRowKind> rowKindsFiltered = new HashSet<MongoRowKind>();
    private static final String pattern = "(\\+I|\\+U|-U|-D|-T|-K|\\+R|\\+B)(&(\\+I|\\+U|-U|-D|-T|-K|\\+R|\\+B))*";

    public RowKindValidator(String rowKinds) {
        if (rowKinds.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)Pattern.matches(pattern, rowKinds), (Object)String.format("rowKinds is not valid, should match the pattern %s, the input value is %s", pattern, rowKinds));
        for (String rowKind : rowKinds.split("&")) {
            Arrays.stream(MongoRowKind.values()).filter(value -> value.shortString().equals(rowKind)).findFirst().ifPresent(this.rowKindsFiltered::add);
        }
    }

    public boolean validate(MongoRowKind rowKind) {
        return this.rowKindsFiltered.contains((Object)rowKind);
    }
}

