/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mongodb.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.relational.Table;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.inlong.sort.cdc.mongodb.debezium.table.MetadataConverter;
import org.apache.inlong.sort.cdc.mongodb.debezium.utils.RecordUtils;
import org.apache.inlong.sort.formats.json.canal.CanalJson;
import org.apache.inlong.sort.formats.json.debezium.DebeziumJson;

public enum MongoDBReadableMetadata {
    COLLECTION("collection_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct to = value.getStruct("ns");
            return StringData.fromString((String)to.getString("coll"));
        }
    }),
    DATABASE("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct to = value.getStruct("ns");
            return StringData.fromString((String)to.getString("db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)source.get("ts_ms")));
        }
    }),
    DATA_DEBEZIUM("meta.data_debezium", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            Struct messageStruct = (Struct)record.value();
            Struct to = messageStruct.getStruct("ns");
            Struct sourceStruct = messageStruct.getStruct("source");
            GenericRowData data = (GenericRowData)rowData;
            Map field = (Map)data.getField(0);
            Map mysqlType = (Map)data.getField(1);
            HashMap sqlType = new HashMap();
            mysqlType.forEach((name, value) -> sqlType.put(name, RecordUtils.getSqlType(value)));
            String debeziumOp = MongoDBReadableMetadata.getDebeziumOpType(rowData);
            if (StringUtils.isBlank((CharSequence)debeziumOp)) {
                return null;
            }
            DebeziumJson.Source source = DebeziumJson.Source.builder().db(to.getString("db")).table(to.getString("coll")).name("mongo_binlog_source").mysqlType(mysqlType).sqlType(sqlType).pkNames(null).build();
            DebeziumJson debeziumJson = DebeziumJson.builder().source(source).after(field).tsMs(((Long)sourceStruct.get("ts_ms")).longValue()).op(debeziumOp).tableChange(tableSchema).build();
            try {
                return StringData.fromString((String)OBJECT_MAPPER.writeValueAsString((Object)debeziumJson));
            }
            catch (Exception e) {
                throw new IllegalStateException("exception occurs when get meta data", e);
            }
        }
    }),
    DATA_CANAL("meta.data_canal", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            Struct messageStruct = (Struct)record.value();
            Struct to = messageStruct.getStruct("ns");
            Struct sourceStruct = messageStruct.getStruct("source");
            String canalOp = MongoDBReadableMetadata.getCanalOpType(rowData);
            if (StringUtils.isBlank((CharSequence)canalOp)) {
                return null;
            }
            GenericRowData data = (GenericRowData)rowData;
            Map field = (Map)data.getField(0);
            Map mysqlType = (Map)data.getField(1);
            HashMap sqlType = new HashMap();
            mysqlType.forEach((name, value) -> sqlType.put(name, RecordUtils.getSqlType(value)));
            ArrayList<Map> dataList = new ArrayList<Map>();
            dataList.add(field);
            CanalJson canalJson = CanalJson.builder().data(dataList).database(to.getString("db")).sql("").es(((Long)sourceStruct.get("ts_ms")).longValue()).isDdl(false).pkNames(null).mysqlType(MongoDBReadableMetadata.getMysqlType(tableSchema)).table(to.getString("coll")).ts(((Long)sourceStruct.get("ts_ms")).longValue()).type(canalOp).sqlType(sqlType).build();
            try {
                return StringData.fromString((String)OBJECT_MAPPER.writeValueAsString((Object)canalJson));
            }
            catch (Exception e) {
                throw new IllegalStateException("exception occurs when get meta data", e);
            }
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;
    private static final ObjectMapper OBJECT_MAPPER;

    private MongoDBReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public static Map<String, String> getMysqlType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, String> mysqlType = new LinkedHashMap<String, String>();
        Table table = tableSchema.getTable();
        table.columns().forEach(column -> mysqlType.put(column.name(), String.format("%s(%d)", column.typeName(), column.length())));
        return mysqlType;
    }

    private static String getDebeziumOpType(RowData rowData) {
        String opType = null;
        switch (rowData.getRowKind()) {
            case INSERT: {
                opType = "c";
                break;
            }
            case DELETE: {
                opType = "d";
                break;
            }
            case UPDATE_AFTER: 
            case UPDATE_BEFORE: {
                opType = "u";
                break;
            }
            default: {
                return null;
            }
        }
        return opType;
    }

    private static String getCanalOpType(RowData rowData) {
        String opType = null;
        switch (rowData.getRowKind()) {
            case INSERT: {
                opType = "INSERT";
                break;
            }
            case DELETE: {
                opType = "DELETE";
                break;
            }
            case UPDATE_AFTER: 
            case UPDATE_BEFORE: {
                opType = "UPDATE";
                break;
            }
            default: {
                return null;
            }
        }
        return opType;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

