/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mongodb.debezium.utils;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.relational.TableId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.bson.BsonType;
import org.bson.BsonValue;

public class RecordUtils {
    public static final String DOCUMENT_TO_FIELD = "to";
    private static final List<BsonType> INT_TYPE = Arrays.asList(BsonType.INT32, BsonType.INT64);
    private static final List<BsonType> BOOL_TYPE = Arrays.asList(BsonType.BOOLEAN);
    private static final List<BsonType> DOUBLE_TYPE = Arrays.asList(BsonType.DOUBLE, BsonType.DECIMAL128);
    private static final List<BsonType> DECIMAL_TYPE = Arrays.asList(new BsonType[0]);
    private static final List<BsonType> TIMESTAMP_TYPE = Arrays.asList(BsonType.DATE_TIME, BsonType.TIMESTAMP);
    private static final List<BsonType> VARCHAR_TYPE = Arrays.asList(BsonType.END_OF_DOCUMENT, BsonType.STRING, BsonType.UNDEFINED, BsonType.OBJECT_ID, BsonType.NULL, BsonType.REGULAR_EXPRESSION, BsonType.DB_POINTER, BsonType.JAVASCRIPT, BsonType.SYMBOL, BsonType.JAVASCRIPT_WITH_SCOPE, BsonType.MIN_KEY, BsonType.MAX_KEY, BsonType.ARRAY, BsonType.DOCUMENT, BsonType.BINARY);
    private static final List<BsonType> ARRAY_TYPE = Arrays.asList(new BsonType[0]);
    private static final List<BsonType> BINARY_TYPE = Arrays.asList(new BsonType[0]);
    private static final Map<String, Integer> SQL_TYPE_MAP = ImmutableMap.builder().put("BIGINT", -5).put("BOOLEAN", 16).put("DOUBLE", 8).put("DECIMAL", 3).put("TIMESTAMP", 93).put("VARCHAR", 12).put("BINARY", -2).put("OTHER", 1111).build();

    public static Integer getSqlType(String sqlTypeStr) {
        return SQL_TYPE_MAP.get(sqlTypeStr) == null ? Integer.valueOf(12) : SQL_TYPE_MAP.get(sqlTypeStr);
    }

    private RecordUtils() {
    }

    public static TableId getTableId(SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("ns");
        String dbName = source.getString("db");
        String tableName = source.getString("coll");
        return new TableId(dbName, null, tableName);
    }

    public static LogicalType convertLogicType(BsonValue bsonValue) {
        BsonType bsonType = bsonValue.getBsonType();
        if (INT_TYPE.contains((Object)bsonType)) {
            return new BigIntType();
        }
        if (BOOL_TYPE.contains((Object)bsonType)) {
            return new BooleanType();
        }
        if (DOUBLE_TYPE.contains((Object)bsonType)) {
            return new DoubleType();
        }
        if (DECIMAL_TYPE.contains((Object)bsonType)) {
            return new DecimalType();
        }
        if (TIMESTAMP_TYPE.contains((Object)bsonType)) {
            return new TimestampType();
        }
        if (VARCHAR_TYPE.contains((Object)bsonType)) {
            return new VarCharType();
        }
        if (BINARY_TYPE.contains((Object)bsonType)) {
            return new BinaryType();
        }
        if (ARRAY_TYPE.contains((Object)bsonType)) {
            return new ArrayType((LogicalType)new IntType());
        }
        return null;
    }
}

