/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.inlong.audit.send.SenderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderHandler
extends SimpleChannelInboundHandler<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderHandler.class);
    private final SenderManager manager;

    public SenderHandler(SenderManager manager) {
        this.manager = manager;
    }

    public void channelRead0(ChannelHandlerContext ctx, byte[] e) {
        try {
            this.manager.onMessageReceived(ctx, e);
        }
        catch (Throwable ex) {
            LOGGER.error("channelRead0 error: ", ex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        try {
            this.manager.onExceptionCaught(ctx, e);
        }
        catch (Throwable ex) {
            LOGGER.error("caught exception: ", ex);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        try {
            super.channelInactive(ctx);
        }
        catch (Throwable ex) {
            LOGGER.error("channelInactive error: ", ex);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelUnregistered(ctx);
        }
        catch (Throwable ex) {
            LOGGER.error("channelUnregistered error: ", ex);
        }
    }
}

