/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.TextNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.NewTopic;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.Callback;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.KafkaProducer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.ByteArraySerializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ThreadUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.JsonUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Platform;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.WorkerUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.WorkerStatusTracker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.Histogram;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.PartitionsSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.PayloadIterator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.ProduceBenchSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.Throttle;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload.TransactionGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceBenchWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ProduceBenchWorker.class);
    private static final int THROTTLE_PERIOD_MS = 100;
    private final String id;
    private final ProduceBenchSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;

    public ProduceBenchWorker(String id, ProduceBenchSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("ProducerBenchWorker is already running.");
        }
        log.info("{}: Activating ProduceBenchWorker with {}", (Object)this.id, (Object)this.spec);
        this.executor = Executors.newScheduledThreadPool(2, ThreadUtils.createThreadFactory("ProduceBenchWorkerThread%d", false));
        this.status = status;
        this.doneFuture = doneFuture;
        this.executor.submit(new Prepare());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ProduceBenchWorker is not running.");
        }
        log.info("{}: Deactivating ProduceBenchWorker.", (Object)this.id);
        this.doneFuture.complete("");
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        this.executor = null;
        this.status = null;
        this.doneFuture = null;
    }

    public static class StatusData {
        private final long totalSent;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;
        private final long transactionsCommitted;
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="totalSent") long totalSent, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs, @JsonProperty(value="transactionsCommitted") long transactionsCommitted) {
            this.totalSent = totalSent;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
            this.transactionsCommitted = transactionsCommitted;
        }

        @JsonProperty
        public long totalSent() {
            return this.totalSent;
        }

        @JsonProperty
        public long transactionsCommitted() {
            return this.transactionsCommitted;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    public class StatusUpdater
    implements Runnable {
        private final Histogram histogram;
        private final AtomicLong transactionsCommitted;

        StatusUpdater(Histogram histogram, AtomicLong transactionsCommitted) {
            this.histogram = histogram;
            this.transactionsCommitted = transactionsCommitted;
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, ProduceBenchWorker.this.doneFuture);
            }
        }

        StatusData update() {
            Histogram.Summary summary = this.histogram.summarize(StatusData.PERCENTILES);
            StatusData statusData = new StatusData(summary.numSamples(), summary.average(), summary.percentiles().get(0).value(), summary.percentiles().get(1).value(), summary.percentiles().get(2).value(), this.transactionsCommitted.get());
            ProduceBenchWorker.this.status.update((JsonNode)JsonUtil.JSON_SERDE.valueToTree(statusData));
            return statusData;
        }
    }

    public class SendRecords
    implements Callable<Void> {
        private final HashSet<TopicPartition> activePartitions;
        private final Histogram histogram;
        private final Future<?> statusUpdaterFuture;
        private final KafkaProducer<byte[], byte[]> producer;
        private final PayloadIterator keys;
        private final PayloadIterator values;
        private final Optional<TransactionGenerator> transactionGenerator;
        private final Throttle throttle;
        private Iterator<TopicPartition> partitionsIterator;
        private Future<RecordMetadata> sendFuture;
        private AtomicLong transactionsCommitted;
        private boolean enableTransactions;

        SendRecords(HashSet<TopicPartition> activePartitions) {
            this.activePartitions = activePartitions;
            this.partitionsIterator = activePartitions.iterator();
            this.histogram = new Histogram(10000);
            this.transactionGenerator = ProduceBenchWorker.this.spec.transactionGenerator();
            this.enableTransactions = this.transactionGenerator.isPresent();
            this.transactionsCommitted = new AtomicLong();
            int perPeriod = WorkerUtils.perSecToPerPeriod(ProduceBenchWorker.this.spec.targetMessagesPerSec(), 100L);
            this.statusUpdaterFuture = ProduceBenchWorker.this.executor.scheduleWithFixedDelay(new StatusUpdater(this.histogram, this.transactionsCommitted), 30L, 30L, TimeUnit.SECONDS);
            Properties props = new Properties();
            props.put("bootstrap.servers", ProduceBenchWorker.this.spec.bootstrapServers());
            if (this.enableTransactions) {
                props.put("transactional.id", "produce-bench-transaction-id-" + UUID.randomUUID());
            }
            WorkerUtils.addConfigsToProperties(props, ProduceBenchWorker.this.spec.commonClientConf(), ProduceBenchWorker.this.spec.producerConf());
            this.producer = new KafkaProducer<byte[], byte[]>(props, (Serializer<byte[]>)new ByteArraySerializer(), (Serializer<byte[]>)new ByteArraySerializer());
            this.keys = new PayloadIterator(ProduceBenchWorker.this.spec.keyGenerator());
            this.values = new PayloadIterator(ProduceBenchWorker.this.spec.valueGenerator());
            this.throttle = ProduceBenchWorker.this.spec.skipFlush() ? new Throttle(perPeriod, 100) : new SendRecordsThrottle(perPeriod, this.producer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long startTimeMs = Time.SYSTEM.milliseconds();
            try {
                try {
                    if (this.enableTransactions) {
                        this.producer.initTransactions();
                    }
                    long sentMessages = 0L;
                    while (sentMessages < ProduceBenchWorker.this.spec.maxMessages()) {
                        boolean tookAction;
                        if (this.enableTransactions && (tookAction = this.takeTransactionAction())) continue;
                        this.sendMessage();
                        ++sentMessages;
                    }
                    if (this.enableTransactions) {
                        this.takeTransactionAction();
                    }
                }
                catch (Exception e) {
                    if (this.enableTransactions) {
                        this.producer.abortTransaction();
                    }
                    throw e;
                }
                finally {
                    if (this.sendFuture != null) {
                        try {
                            this.sendFuture.get();
                        }
                        catch (Exception e) {
                            log.error("Exception on final future", (Throwable)e);
                        }
                    }
                    this.producer.close();
                }
                this.statusUpdaterFuture.cancel(false);
            }
            catch (Exception e) {
                try {
                    WorkerUtils.abort(log, "SendRecords", e, ProduceBenchWorker.this.doneFuture);
                    this.statusUpdaterFuture.cancel(false);
                }
                catch (Throwable throwable) {
                    this.statusUpdaterFuture.cancel(false);
                    StatusData statusData = new StatusUpdater(this.histogram, this.transactionsCommitted).update();
                    long curTimeMs = Time.SYSTEM.milliseconds();
                    log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
                    throw throwable;
                }
                StatusData statusData = new StatusUpdater(this.histogram, this.transactionsCommitted).update();
                long curTimeMs = Time.SYSTEM.milliseconds();
                log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
            }
            StatusData statusData = new StatusUpdater(this.histogram, this.transactionsCommitted).update();
            long curTimeMs = Time.SYSTEM.milliseconds();
            log.info("Sent {} total record(s) in {} ms.  status: {}", new Object[]{this.histogram.summarize().numSamples(), curTimeMs - startTimeMs, statusData});
            ProduceBenchWorker.this.doneFuture.complete("");
            return null;
        }

        private boolean takeTransactionAction() {
            boolean tookAction = true;
            TransactionGenerator.TransactionAction nextAction = this.transactionGenerator.get().nextAction();
            switch (nextAction) {
                case BEGIN_TRANSACTION: {
                    log.debug("Beginning transaction.");
                    this.producer.beginTransaction();
                    break;
                }
                case COMMIT_TRANSACTION: {
                    log.debug("Committing transaction.");
                    this.producer.commitTransaction();
                    this.transactionsCommitted.getAndIncrement();
                    break;
                }
                case ABORT_TRANSACTION: {
                    log.debug("Aborting transaction.");
                    this.producer.abortTransaction();
                    break;
                }
                case NO_OP: {
                    tookAction = false;
                }
            }
            return tookAction;
        }

        private void sendMessage() throws InterruptedException {
            if (!this.partitionsIterator.hasNext()) {
                this.partitionsIterator = this.activePartitions.iterator();
            }
            TopicPartition partition = this.partitionsIterator.next();
            ProducerRecord<byte[], byte[]> record = ProduceBenchWorker.this.spec.useConfiguredPartitioner() ? new ProducerRecord<byte[], byte[]>(partition.topic(), this.keys.next(), this.values.next()) : new ProducerRecord<byte[], byte[]>(partition.topic(), partition.partition(), this.keys.next(), this.values.next());
            this.sendFuture = this.producer.send(record, new SendRecordsCallback(this, Time.SYSTEM.milliseconds()));
            this.throttle.increment();
        }

        void recordDuration(long durationMs) {
            this.histogram.add(durationMs);
        }
    }

    private static class SendRecordsThrottle
    extends Throttle {
        private final KafkaProducer<?, ?> producer;

        SendRecordsThrottle(int maxPerPeriod, KafkaProducer<?, ?> producer) {
            super(maxPerPeriod, 100);
            this.producer = producer;
        }

        @Override
        protected synchronized void delay(long amount) throws InterruptedException {
            long startMs = this.time().milliseconds();
            this.producer.flush();
            long endMs = this.time().milliseconds();
            long delta = endMs - startMs;
            super.delay(amount - delta);
        }
    }

    private static class SendRecordsCallback
    implements Callback {
        private final SendRecords sendRecords;
        private final long startMs;

        SendRecordsCallback(SendRecords sendRecords, long startMs) {
            this.sendRecords = sendRecords;
            this.startMs = startMs;
        }

        @Override
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = Time.SYSTEM.milliseconds();
            long durationMs = now - this.startMs;
            this.sendRecords.recordDuration(durationMs);
            if (exception != null) {
                log.error("SendRecordsCallback: error", (Throwable)exception);
            }
        }
    }

    public class Prepare
    implements Runnable {
        @Override
        public void run() {
            try {
                PartitionsSpec partSpec;
                String topicName;
                HashMap<String, NewTopic> newTopics = new HashMap<String, NewTopic>();
                HashSet<TopicPartition> active = new HashSet<TopicPartition>();
                for (Map.Entry<String, PartitionsSpec> entry : ProduceBenchWorker.this.spec.activeTopics().materialize().entrySet()) {
                    topicName = entry.getKey();
                    partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                    for (Integer partitionNumber : partSpec.partitionNumbers()) {
                        active.add(new TopicPartition(topicName, partitionNumber));
                    }
                }
                if (active.isEmpty()) {
                    throw new RuntimeException("You must specify at least one active topic.");
                }
                for (Map.Entry<String, PartitionsSpec> entry : ProduceBenchWorker.this.spec.inactiveTopics().materialize().entrySet()) {
                    topicName = entry.getKey();
                    partSpec = entry.getValue();
                    newTopics.put(topicName, partSpec.newTopic(topicName));
                }
                ProduceBenchWorker.this.status.update(new TextNode("Creating " + newTopics.keySet().size() + " topic(s)"));
                WorkerUtils.createTopics(log, ProduceBenchWorker.this.spec.bootstrapServers(), ProduceBenchWorker.this.spec.commonClientConf(), ProduceBenchWorker.this.spec.adminClientConf(), newTopics, false);
                ProduceBenchWorker.this.status.update(new TextNode("Created " + newTopics.keySet().size() + " topic(s)"));
                ProduceBenchWorker.this.executor.submit(new SendRecords(active));
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, ProduceBenchWorker.this.doneFuture);
            }
        }
    }
}

