/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class ListPartitionReassignmentsRequest
extends AbstractRequest {
    private ListPartitionReassignmentsRequestData data;
    private final short version;

    private ListPartitionReassignmentsRequest(ListPartitionReassignmentsRequestData data, short version) {
        super(ApiKeys.LIST_PARTITION_REASSIGNMENTS, version);
        this.data = data;
        this.version = version;
    }

    ListPartitionReassignmentsRequest(Struct struct, short version) {
        super(ApiKeys.LIST_PARTITION_REASSIGNMENTS, version);
        this.data = new ListPartitionReassignmentsRequestData(struct, version);
        this.version = version;
    }

    public static ListPartitionReassignmentsRequest parse(ByteBuffer buffer, short version) {
        return new ListPartitionReassignmentsRequest(ApiKeys.LIST_PARTITION_REASSIGNMENTS.parseRequest(version, buffer), version);
    }

    public ListPartitionReassignmentsRequestData data() {
        return this.data;
    }

    @Override
    public Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<ListPartitionReassignmentsResponseData.OngoingTopicReassignment> ongoingTopicReassignments = new ArrayList<ListPartitionReassignmentsResponseData.OngoingTopicReassignment>();
        if (this.data.topics() != null) {
            for (ListPartitionReassignmentsRequestData.ListPartitionReassignmentsTopics topic : this.data.topics()) {
                ongoingTopicReassignments.add(new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName(topic.name()).setPartitions(topic.partitionIndexes().stream().map(partitionIndex -> new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex((int)partitionIndex)).collect(Collectors.toList())));
            }
        }
        ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(ongoingTopicReassignments).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new ListPartitionReassignmentsResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<ListPartitionReassignmentsRequest> {
        private final ListPartitionReassignmentsRequestData data;

        public Builder(ListPartitionReassignmentsRequestData data) {
            super(ApiKeys.LIST_PARTITION_REASSIGNMENTS);
            this.data = data;
        }

        @Override
        public ListPartitionReassignmentsRequest build(short version) {
            return new ListPartitionReassignmentsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

