/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.AbstractOptions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.util.Optional;

public final class ConsumerGroupOperationContext<T, O extends AbstractOptions<O>> {
    private final String groupId;
    private final O options;
    private final long deadline;
    private final KafkaFutureImpl<T> future;
    private Optional<Node> node;

    public ConsumerGroupOperationContext(String groupId, O options, long deadline, KafkaFutureImpl<T> future) {
        this.groupId = groupId;
        this.options = options;
        this.deadline = deadline;
        this.future = future;
        this.node = Optional.empty();
    }

    public String groupId() {
        return this.groupId;
    }

    public O options() {
        return this.options;
    }

    public long deadline() {
        return this.deadline;
    }

    public KafkaFutureImpl<T> future() {
        return this.future;
    }

    public Optional<Node> node() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = Optional.ofNullable(node);
    }

    public static boolean hasCoordinatorMoved(AbstractResponse response) {
        return response.errorCounts().keySet().stream().anyMatch(error -> error == Errors.NOT_COORDINATOR);
    }

    public static boolean shouldRefreshCoordinator(Errors error) {
        return error == Errors.COORDINATOR_LOAD_IN_PROGRESS || error == Errors.COORDINATOR_NOT_AVAILABLE;
    }
}

