/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.ververica.cdc.connectors.mongodb.internal.MongoDBConnectorSourceConnector;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.Validator;
import io.debezium.heartbeat.Heartbeat;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class MongoDBSource {
    public static final String MONGODB_SCHEME = "mongodb";
    public static final String ERROR_TOLERANCE_NONE = MongoSourceConfig.ErrorTolerance.NONE.value();
    public static final String ERROR_TOLERANCE_ALL = MongoSourceConfig.ErrorTolerance.ALL.value();
    public static final String FULL_DOCUMENT_UPDATE_LOOKUP = FullDocument.UPDATE_LOOKUP.getValue();
    public static final int POLL_MAX_BATCH_SIZE_DEFAULT = 1000;
    public static final int POLL_AWAIT_TIME_MILLIS_DEFAULT = 1500;
    public static final String HEARTBEAT_TOPIC_NAME_DEFAULT = "__mongodb_heartbeats";
    public static final String OUTPUT_FORMAT_SCHEMA = MongoSourceConfig.OutputFormat.SCHEMA.name().toLowerCase(Locale.ROOT);
    public static final String OUTPUT_SCHEMA_VALUE_DEFAULT = "{  \"name\": \"ChangeStream\",  \"type\": \"record\",  \"fields\": [    { \"name\": \"_id\", \"type\": \"string\" },    { \"name\": \"operationType\", \"type\": [\"string\", \"null\"] },    { \"name\": \"fullDocument\", \"type\": [\"string\", \"null\"] },    { \"name\": \"source\",      \"type\": [{\"name\": \"source\", \"type\": \"record\", \"fields\": [                {\"name\": \"ts_ms\", \"type\": \"long\"},                {\"name\": \"snapshot\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"ns\",      \"type\": [{\"name\": \"ns\", \"type\": \"record\", \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"to\",      \"type\": [{\"name\": \"to\", \"type\": \"record\",  \"fields\": [                {\"name\": \"db\", \"type\": \"string\"},                {\"name\": \"coll\", \"type\": [\"string\", \"null\"] } ]               }, \"null\" ] },    { \"name\": \"documentKey\", \"type\": [\"string\", \"null\"] },    { \"name\": \"updateDescription\",      \"type\": [{\"name\": \"updateDescription\",  \"type\": \"record\", \"fields\": [                 {\"name\": \"updatedFields\", \"type\": [\"string\", \"null\"]},                 {\"name\": \"removedFields\",                  \"type\": [{\"type\": \"array\", \"items\": \"string\"}, \"null\"]                  }] }, \"null\"] },    { \"name\": \"clusterTime\", \"type\": [\"string\", \"null\"] },    { \"name\": \"txnNumber\", \"type\": [\"long\", \"null\"]},    { \"name\": \"lsid\", \"type\": [{\"name\": \"lsid\", \"type\": \"record\",               \"fields\": [ {\"name\": \"id\", \"type\": \"string\"},                             {\"name\": \"uid\", \"type\": \"string\"}] }, \"null\"] }  ]}";

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder<T> {
        private String hosts;
        private String username;
        private String password;
        private List<String> databaseList;
        private List<String> collectionList;
        private String connectionOptions;
        private Integer batchSize;
        private Integer pollAwaitTimeMillis = 1500;
        private Integer pollMaxBatchSize = 1000;
        private Boolean copyExisting = true;
        private Integer copyExistingMaxThreads;
        private Integer copyExistingQueueSize;
        private String copyExistingPipeline;
        private Boolean errorsLogEnable;
        private String errorsTolerance;
        private Integer heartbeatIntervalMillis;
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder<T> connectionOptions(String connectionOptions) {
            this.connectionOptions = connectionOptions;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> databaseList(String ... databaseList) {
            this.databaseList = Arrays.asList(databaseList);
            return this;
        }

        public Builder<T> collectionList(String ... collectionList) {
            this.collectionList = Arrays.asList(collectionList);
            return this;
        }

        public Builder<T> batchSize(int batchSize) {
            Preconditions.checkArgument((batchSize >= 0 ? 1 : 0) != 0);
            this.batchSize = batchSize;
            return this;
        }

        public Builder<T> pollAwaitTimeMillis(int pollAwaitTimeMillis) {
            Preconditions.checkArgument((pollAwaitTimeMillis > 0 ? 1 : 0) != 0);
            this.pollAwaitTimeMillis = pollAwaitTimeMillis;
            return this;
        }

        public Builder<T> pollMaxBatchSize(int pollMaxBatchSize) {
            Preconditions.checkArgument((pollMaxBatchSize > 0 ? 1 : 0) != 0);
            this.pollMaxBatchSize = pollMaxBatchSize;
            return this;
        }

        public Builder<T> copyExisting(boolean copyExisting) {
            this.copyExisting = copyExisting;
            return this;
        }

        public Builder<T> copyExistingMaxThreads(int copyExistingMaxThreads) {
            Preconditions.checkArgument((copyExistingMaxThreads > 0 ? 1 : 0) != 0);
            this.copyExistingMaxThreads = copyExistingMaxThreads;
            return this;
        }

        public Builder<T> copyExistingQueueSize(int copyExistingQueueSize) {
            Preconditions.checkArgument((copyExistingQueueSize > 0 ? 1 : 0) != 0);
            this.copyExistingQueueSize = copyExistingQueueSize;
            return this;
        }

        public Builder<T> copyExistingPipeline(String copyExistingPipeline) {
            this.copyExistingPipeline = copyExistingPipeline;
            return this;
        }

        public Builder<T> errorsLogEnable(boolean errorsLogEnable) {
            this.errorsLogEnable = errorsLogEnable;
            return this;
        }

        public Builder<T> errorsTolerance(String errorsTolerance) {
            this.errorsTolerance = errorsTolerance;
            return this;
        }

        public Builder<T> heartbeatIntervalMillis(int heartbeatIntervalMillis) {
            Preconditions.checkArgument((heartbeatIntervalMillis >= 0 ? 1 : 0) != 0);
            this.heartbeatIntervalMillis = heartbeatIntervalMillis;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @VisibleForTesting
        public ConnectionString buildConnectionUri() {
            StringBuilder sb = new StringBuilder(MongoDBSource.MONGODB_SCHEME).append("://");
            if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
                sb.append(MongoDBSource.encodeValue(this.username)).append(":").append(MongoDBSource.encodeValue(this.password)).append("@");
            }
            sb.append((String)Preconditions.checkNotNull((Object)this.hosts));
            if (StringUtils.isNotEmpty((CharSequence)this.connectionOptions)) {
                sb.append("/?").append(this.connectionOptions);
            }
            return new ConnectionString(sb.toString());
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", MongoDBConnectorSourceConnector.class.getCanonicalName());
            props.setProperty("name", "mongodb_binlog_source");
            ConnectionString connectionString = this.buildConnectionUri();
            props.setProperty("connection.uri", String.valueOf(connectionString));
            if (this.databaseList != null) {
                props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
            }
            if (this.collectionList != null) {
                props.setProperty("collection.include.list", String.join((CharSequence)",", this.collectionList));
            }
            props.setProperty("change.stream.full.document", FULL_DOCUMENT_UPDATE_LOOKUP);
            props.setProperty("publish.full.document.only", String.valueOf(Boolean.FALSE));
            props.setProperty("output.format.key", OUTPUT_FORMAT_SCHEMA);
            props.setProperty("output.format.value", OUTPUT_FORMAT_SCHEMA);
            props.setProperty("output.schema.infer.value", String.valueOf(Boolean.FALSE));
            props.setProperty("output.schema.value", MongoDBSource.OUTPUT_SCHEMA_VALUE_DEFAULT);
            if (this.batchSize != null) {
                props.setProperty("batch.size", String.valueOf(this.batchSize));
            }
            if (this.pollAwaitTimeMillis != null) {
                props.setProperty("poll.await.time.ms", String.valueOf(this.pollAwaitTimeMillis));
            }
            if (this.pollMaxBatchSize != null) {
                props.setProperty("poll.max.batch.size", String.valueOf(this.pollMaxBatchSize));
            }
            if (this.errorsLogEnable != null) {
                props.setProperty("errors.log.enable", String.valueOf(this.errorsLogEnable));
            }
            if (this.errorsTolerance != null) {
                props.setProperty("errors.tolerance", this.errorsTolerance);
            }
            if (this.copyExisting != null) {
                props.setProperty("copy.existing", String.valueOf(this.copyExisting));
            }
            if (this.copyExistingMaxThreads != null) {
                props.setProperty("copy.existing.max.threads", String.valueOf(this.copyExistingMaxThreads));
            }
            if (this.copyExistingQueueSize != null) {
                props.setProperty("copy.existing.queue.size", String.valueOf(this.copyExistingQueueSize));
            }
            if (this.copyExistingPipeline != null) {
                props.setProperty("copy.existing.pipeline", this.copyExistingPipeline);
            }
            if (this.heartbeatIntervalMillis != null) {
                props.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatIntervalMillis));
            }
            props.setProperty("heartbeat.topic.name", MongoDBSource.HEARTBEAT_TOPIC_NAME_DEFAULT);
            props.setProperty(Heartbeat.HEARTBEAT_TOPICS_PREFIX.name(), MongoDBSource.HEARTBEAT_TOPIC_NAME_DEFAULT);
            return new DebeziumSourceFunction<T>(this.deserializer, props, null, Validator.getDefaultValidator());
        }
    }
}

