/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

public class FlexibleDateTimeParser {
    private static final String TIME = "HH:mm:ss";
    private static final String OPTIONAL_NANO_SECONDS = "[[.][SSSSSS][SSS]]";
    private static final String OPTIONAL_TIME_WITH_TIMEZONE = String.format("[%s%s[ ]VV[ ]'['VV']']", "HH:mm:ss", "[[.][SSSSSS][SSS]]");
    private static final String OPTIONAL_TIME_WITH_OFFSET = String.format("[%s%s[ ]X]", "HH:mm:ss", "[[.][SSSSSS][SSS]]");
    private static final String OPTIONAL_TIME = String.format("[%s%s]", "HH:mm:ss", "[[.][SSSSSS][SSS]]");
    public static final String DEFAULT_DATE_TIME_FORMATTER_PATTERN = "yyyy-MM-dd[['T'][ ]]" + OPTIONAL_TIME_WITH_TIMEZONE + OPTIONAL_TIME_WITH_OFFSET + OPTIONAL_TIME;
    private final DateTimeFormatter formatter;

    public FlexibleDateTimeParser(String dateTimePattern, String languageTag) {
        Locale locale = languageTag.isEmpty() ? Locale.ROOT : Locale.forLanguageTag(languageTag);
        this.formatter = DateTimeFormatter.ofPattern(dateTimePattern, locale);
    }

    public long toEpochMilli(String dateTimeString) {
        TemporalAccessor parsed = this.formatter.parse(dateTimeString);
        if (parsed.isSupported(ChronoField.INSTANT_SECONDS)) {
            return Instant.from(parsed).toEpochMilli();
        }
        if (parsed.isSupported(ChronoField.SECOND_OF_MINUTE)) {
            return LocalDateTime.from(parsed).atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        if (parsed.isSupported(ChronoField.DAY_OF_MONTH)) {
            return LocalDate.from(parsed).atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        throw new DateTimeParseException("Unsupported date time string", dateTimeString, 0);
    }
}

