/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.schema;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public final class BsonDocumentToSchema {
    private static final String ID_FIELD = "_id";
    private static final Schema DEFAULT_INFER_SCHEMA_TYPE = Schema.OPTIONAL_STRING_SCHEMA;
    public static final String DEFAULT_FIELD_NAME = "default";

    public static Schema inferDocumentSchema(BsonDocument document) {
        return BsonDocumentToSchema.createSchemaBuilder(DEFAULT_FIELD_NAME, document).required().build();
    }

    private static Schema inferDocumentSchema(String fieldPath, BsonDocument document) {
        return BsonDocumentToSchema.createSchemaBuilder(fieldPath, document).optional().build();
    }

    private static SchemaBuilder createSchemaBuilder(String fieldPath, BsonDocument document) {
        SchemaBuilder builder = SchemaBuilder.struct();
        builder.name(fieldPath);
        if (document.containsKey(ID_FIELD)) {
            builder.field(ID_FIELD, BsonDocumentToSchema.inferSchema(ID_FIELD, document.get(ID_FIELD)));
        }
        document.entrySet().stream().filter(kv -> !((String)kv.getKey()).equals(ID_FIELD)).sorted(Map.Entry.comparingByKey()).forEach(kv -> builder.field((String)kv.getKey(), BsonDocumentToSchema.inferSchema(BsonDocumentToSchema.createFieldPath(fieldPath, (String)kv.getKey()), (BsonValue)kv.getValue())));
        return builder;
    }

    private static Schema inferSchema(String fieldPath, BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case INT32: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case DECIMAL128: {
                return Decimal.builder(bsonValue.asDecimal128().getValue().bigDecimalValue().scale()).optional().build();
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case DOCUMENT: {
                return BsonDocumentToSchema.inferDocumentSchema(fieldPath, bsonValue.asDocument());
            }
            case ARRAY: {
                Schema firstItemSchema;
                List<BsonValue> values = bsonValue.asArray().getValues();
                Schema schema = firstItemSchema = values.isEmpty() ? DEFAULT_INFER_SCHEMA_TYPE : BsonDocumentToSchema.inferSchema(fieldPath, values.get(0));
                if (values.isEmpty() || values.stream().anyMatch(bv -> !Objects.equals(BsonDocumentToSchema.inferSchema(fieldPath, bv), firstItemSchema))) {
                    return SchemaBuilder.array(DEFAULT_INFER_SCHEMA_TYPE).name(fieldPath).optional().build();
                }
                return SchemaBuilder.array(BsonDocumentToSchema.inferSchema(fieldPath, bsonValue.asArray().getValues().get(0))).name(fieldPath).optional().build();
            }
            case BINARY: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case SYMBOL: 
            case STRING: 
            case NULL: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
        }
        return DEFAULT_INFER_SCHEMA_TYPE;
    }

    private static String createFieldPath(String fieldPath, String fieldName) {
        if (fieldPath.equals(DEFAULT_FIELD_NAME)) {
            return fieldName;
        }
        return fieldPath + "_" + fieldName;
    }

    private BsonDocumentToSchema() {
    }
}

