/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.schema;

import com.ververica.cdc.connectors.shaded.org.apache.avro.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class AvroSchema {
    public static com.ververica.cdc.connectors.shaded.org.apache.avro.Schema validateJsonSchema(String jsonSchema) {
        com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema = AvroSchema.parseSchema(jsonSchema);
        if (avroSchema.getType() != Schema.Type.RECORD) {
            throw new ConnectException("Only Record schemas are supported at the top-level.");
        }
        AvroSchema.validateAvroSchema(avroSchema, "", new ArrayList<String>());
        return avroSchema;
    }

    private static void validateAvroSchema(com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema, String fieldPath, List<String> recordList) {
        switch (avroSchema.getType()) {
            case RECORD: {
                if (recordList.contains(avroSchema.getFullName())) break;
                recordList.add(avroSchema.getFullName());
                avroSchema.getFields().forEach(f -> {
                    String newFieldPath = fieldPath.isEmpty() ? f.name() : String.format("%s.%s", fieldPath, f.name());
                    AvroSchema.validateAvroSchema(f.schema(), newFieldPath, recordList);
                });
                break;
            }
            case ARRAY: {
                AvroSchema.validateAvroSchema(avroSchema.getElementType(), fieldPath, recordList);
                break;
            }
            case MAP: {
                AvroSchema.validateAvroSchema(avroSchema.getValueType(), fieldPath, recordList);
                break;
            }
            case UNION: {
                if (avroSchema.getTypes().size() == 2 && !avroSchema.getTypes().stream().noneMatch(s -> s.getType() == Schema.Type.NULL)) break;
                throw AvroSchema.createConnectException("Union Schemas are not supported, unless one value is null to represent an optional value.", fieldPath);
            }
            case FIXED: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'. The connector will not validate the length. Use bytes instead.", new Object[]{avroSchema.getType()}), fieldPath);
            }
            case ENUM: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'. The connector will not validate the values. Use string instead.", new Object[]{avroSchema.getType()}), fieldPath);
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return;
            }
            default: {
                throw AvroSchema.createConnectException(String.format("Unsupported Avro schema type: '%s'.", new Object[]{avroSchema.getType()}), fieldPath);
            }
        }
    }

    public static Schema fromJson(String jsonSchema) {
        com.ververica.cdc.connectors.shaded.org.apache.avro.Schema parsedSchema = AvroSchema.validateJsonSchema(jsonSchema);
        return AvroSchema.createSchema(parsedSchema);
    }

    static com.ververica.cdc.connectors.shaded.org.apache.avro.Schema parseSchema(String jsonSchema) {
        try {
            return new Schema.Parser().setValidate(false).parse(jsonSchema);
        }
        catch (Exception e) {
            throw new ConnectException(String.format("Invalid Avro schema. %s\n%s", e.getMessage(), jsonSchema));
        }
    }

    static Schema createSchema(com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema) {
        return AvroSchema.createSchema(avroSchema, false, new Context());
    }

    static Schema createSchema(com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema, boolean isOptional, Context context) {
        return AvroSchema.createSchema(avroSchema, isOptional, null, context);
    }

    static Schema createSchema(com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema, boolean isOptional, Object defaultValue, Context context) {
        SchemaBuilder builder;
        switch (avroSchema.getType()) {
            case RECORD: {
                SchemaBuilder structBuilder = SchemaBuilder.struct();
                context.schemaCache.put(avroSchema, structBuilder);
                structBuilder.name(avroSchema.getName());
                avroSchema.getFields().forEach(f -> {
                    if (context.schemaCache.containsKey(f.schema())) {
                        context.detectedCycles.add(f.schema());
                        structBuilder.field(f.name(), (Schema)context.schemaCache.get(f.schema()));
                    } else {
                        Schema fieldSchema = AvroSchema.createSchema(f.schema(), false, f.defaultVal(), context);
                        structBuilder.field(f.name(), fieldSchema);
                    }
                });
                builder = structBuilder;
                break;
            }
            case MAP: {
                builder = SchemaBuilder.map(Schema.STRING_SCHEMA, AvroSchema.createSchemaCheckCycles(avroSchema.getValueType(), defaultValue, context));
                break;
            }
            case ARRAY: {
                builder = SchemaBuilder.array(AvroSchema.createSchemaCheckCycles(avroSchema.getElementType(), defaultValue, context));
                break;
            }
            case STRING: {
                builder = SchemaBuilder.string();
                break;
            }
            case FIXED: 
            case BYTES: {
                builder = SchemaBuilder.bytes();
                break;
            }
            case INT: {
                builder = SchemaBuilder.int32();
                break;
            }
            case LONG: {
                builder = SchemaBuilder.int64();
                break;
            }
            case FLOAT: {
                builder = SchemaBuilder.float32();
                break;
            }
            case DOUBLE: {
                builder = SchemaBuilder.float64();
                break;
            }
            case BOOLEAN: {
                builder = SchemaBuilder.bool();
                break;
            }
            case UNION: {
                Optional<com.ververica.cdc.connectors.shaded.org.apache.avro.Schema> optionalSchema = avroSchema.getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).findFirst();
                if (optionalSchema.isPresent()) {
                    return AvroSchema.createSchema(optionalSchema.get(), true, context);
                }
                throw new IllegalStateException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (isOptional) {
            builder.optional();
        }
        if (defaultValue != null) {
            builder.defaultValue(AvroSchema.processDefaultValue(builder, defaultValue));
        }
        if (!context.detectedCycles.contains(avroSchema)) {
            context.schemaCache.remove(avroSchema);
        }
        return builder.build();
    }

    static Object processDefaultValue(SchemaBuilder schemaBuilder, Object value) {
        if (schemaBuilder.type() == Schema.Type.STRUCT) {
            Struct structValue = new Struct(schemaBuilder);
            if (value instanceof Map) {
                Map defaultMap = (Map)value;
                structValue.schema().fields().forEach(f -> {
                    if (defaultMap.containsKey(f.name())) {
                        structValue.put((Field)f, defaultMap.get(f.name()));
                    }
                });
            }
            return structValue;
        }
        return value;
    }

    static Schema createSchemaCheckCycles(com.ververica.cdc.connectors.shaded.org.apache.avro.Schema avroSchema, Object defaultValue, Context context) {
        Schema resolvedSchema;
        if (context.schemaCache.containsKey(avroSchema)) {
            context.detectedCycles.add(avroSchema);
            resolvedSchema = ((Schema)context.schemaCache.get(avroSchema)).schema();
        } else {
            resolvedSchema = AvroSchema.createSchema(avroSchema, false, defaultValue, context);
        }
        return resolvedSchema;
    }

    private static ConnectException createConnectException(String message, String fieldPath) {
        String errorMessage = message;
        if (!fieldPath.isEmpty()) {
            errorMessage = String.format("Field '%s' is invalid. %s", fieldPath, message);
        }
        return new ConnectException(errorMessage);
    }

    private AvroSchema() {
    }

    private static final class Context {
        private final Map<com.ververica.cdc.connectors.shaded.org.apache.avro.Schema, Schema> schemaCache = new IdentityHashMap<com.ververica.cdc.connectors.shaded.org.apache.avro.Schema, Schema>();
        private final Set<com.ververica.cdc.connectors.shaded.org.apache.avro.Schema> detectedCycles = new HashSet<com.ververica.cdc.connectors.shaded.org.apache.avro.Schema>();

        private Context() {
        }
    }
}

