/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.kafka.connect.source.MongoCopyDataManager;
import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.heartbeat.HeartbeatManager;
import com.mongodb.kafka.connect.source.producer.SchemaAndValueProducer;
import com.mongodb.kafka.connect.source.producer.SchemaAndValueProducers;
import com.mongodb.kafka.connect.source.topic.mapping.TopicMapper;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.SystemTime;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoSourceTask
extends SourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSourceTask.class);
    private static final String CONNECTOR_TYPE = "source";
    public static final String ID_FIELD = "_id";
    private static final String COPY_KEY = "copy";
    private static final String NS_KEY = "ns";
    private static final String FULL_DOCUMENT = "fullDocument";
    private static final int NAMESPACE_NOT_FOUND_ERROR = 26;
    private static final int ILLEGAL_OPERATION_ERROR = 20;
    private static final int INVALIDATED_RESUME_TOKEN_ERROR = 260;
    private static final int CHANGE_STREAM_FATAL_ERROR = 280;
    private static final int CHANGE_STREAM_HISTORY_LOST = 286;
    private static final int BSON_OBJECT_TOO_LARGE = 10334;
    private static final Set<Integer> INVALID_CHANGE_STREAM_ERRORS = new HashSet<Integer>(Arrays.asList(260, 280, 286, 10334));
    private static final int UNKNOWN_FIELD_ERROR = 40415;
    private static final int FAILED_TO_PARSE_ERROR = 9;
    private static final String RESUME_TOKEN = "resume token";
    private static final String RESUME_POINT = "resume point";
    private static final String NOT_FOUND = "not found";
    private static final String DOES_NOT_EXIST = "does not exist";
    private static final String INVALID_RESUME_TOKEN = "invalid resume token";
    private static final String NO_LONGER_IN_THE_OPLOG = "no longer be in the oplog";
    private final Time time;
    private final AtomicBoolean isRunning = new AtomicBoolean();
    private final AtomicBoolean isCopying = new AtomicBoolean();
    private MongoSourceConfig sourceConfig;
    private Map<String, Object> partitionMap;
    private MongoClient mongoClient;
    private HeartbeatManager heartbeatManager;
    private boolean supportsStartAfter = true;
    private boolean invalidatedCursor = false;
    private MongoCopyDataManager copyDataManager;
    private BsonDocument cachedResult;
    private BsonDocument cachedResumeToken;
    private MongoChangeStreamCursor<? extends BsonDocument> cursor;

    public MongoSourceTask() {
        this(new SystemTime());
    }

    private MongoSourceTask(Time time) {
        this.time = time;
    }

    @Override
    public String version() {
        return "1.6.1";
    }

    @Override
    public void start(Map<String, String> props) {
        LOGGER.info("Starting MongoDB source task");
        try {
            this.sourceConfig = new MongoSourceConfig(props);
        }
        catch (Exception e) {
            throw new ConnectException("Failed to start new task", e);
        }
        this.partitionMap = null;
        this.createPartitionMap(this.sourceConfig);
        MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(this.sourceConfig.getConnectionString());
        ServerApiConfig.setServerApi(builder, this.sourceConfig);
        this.mongoClient = MongoClients.create(builder.build(), ConfigHelper.getMongoDriverInformation(CONNECTOR_TYPE, this.sourceConfig.getString("provider")));
        if (this.shouldCopyData()) {
            this.setCachedResultAndResumeToken();
            this.copyDataManager = new MongoCopyDataManager(this.sourceConfig, this.mongoClient);
            this.isCopying.set(true);
        } else {
            this.initializeCursorAndHeartbeatManager(this.time, this.sourceConfig, this.mongoClient);
        }
        this.isRunning.set(true);
        LOGGER.info("Started MongoDB source task");
    }

    @Override
    public List<SourceRecord> poll() {
        long startPoll = this.time.milliseconds();
        LOGGER.debug("Polling Start: {}", (Object)startPoll);
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        TopicMapper topicMapper = this.sourceConfig.getTopicMapper();
        boolean publishFullDocumentOnly = this.sourceConfig.getBoolean("publish.full.document.only");
        int maxBatchSize = this.sourceConfig.getInt("poll.max.batch.size");
        long nextUpdate = startPoll + this.sourceConfig.getLong("poll.await.time.ms");
        Map<String, Object> partition = this.createPartitionMap(this.sourceConfig);
        SchemaAndValueProducer keySchemaAndValueProducer = SchemaAndValueProducers.createKeySchemaAndValueProvider(this.sourceConfig);
        SchemaAndValueProducer valueSchemaAndValueProducer = SchemaAndValueProducers.createValueSchemaAndValueProvider(this.sourceConfig);
        while (this.isRunning.get()) {
            String topicName;
            Optional<BsonDocument> next = this.getNextDocument();
            long untilNext = nextUpdate - this.time.milliseconds();
            if (!next.isPresent()) {
                if (untilNext > 0L) {
                    LOGGER.debug("Waiting {} ms to poll", (Object)untilNext);
                    this.time.sleep(untilNext);
                    continue;
                }
                if (!sourceRecords.isEmpty()) {
                    return sourceRecords;
                }
                if (this.heartbeatManager != null) {
                    return this.heartbeatManager.heartbeat().map(Collections::singletonList).orElse(null);
                }
                return null;
            }
            BsonDocument changeStreamDocument = next.get();
            HashMap<String, String> sourceOffset = new HashMap<String, String>();
            sourceOffset.put(ID_FIELD, changeStreamDocument.getDocument(ID_FIELD).toJson());
            if (this.isCopying.get()) {
                sourceOffset.put(COPY_KEY, "true");
            }
            if ((topicName = topicMapper.getTopic(changeStreamDocument)).isEmpty()) {
                LOGGER.warn("No topic set. Could not publish the message: {}", (Object)changeStreamDocument.toJson());
                return sourceRecords;
            }
            Optional<Object> valueDocument = Optional.empty();
            if (publishFullDocumentOnly) {
                if (changeStreamDocument.containsKey(FULL_DOCUMENT) && changeStreamDocument.get(FULL_DOCUMENT).isDocument()) {
                    valueDocument = Optional.of(changeStreamDocument.getDocument(FULL_DOCUMENT));
                }
            } else {
                valueDocument = Optional.of(changeStreamDocument);
            }
            valueDocument.ifPresent(valueDoc -> {
                LOGGER.trace("Adding {} to {}: {}", new Object[]{valueDoc, topicName, sourceOffset});
                BsonDocument keyDocument = this.sourceConfig.getKeyOutputFormat() == MongoSourceConfig.OutputFormat.SCHEMA ? changeStreamDocument : new BsonDocument(ID_FIELD, changeStreamDocument.get(ID_FIELD));
                this.createSourceRecord(partition, keySchemaAndValueProducer, valueSchemaAndValueProducer, (Map<String, String>)sourceOffset, topicName, keyDocument, (BsonDocument)valueDoc).map(sourceRecords::add);
            });
            if (sourceRecords.size() != maxBatchSize) continue;
            LOGGER.debug("Reached '{}': {}, returning records", (Object)"poll.max.batch.size", (Object)maxBatchSize);
            return sourceRecords;
        }
        return null;
    }

    private Optional<SourceRecord> createSourceRecord(Map<String, Object> partition, SchemaAndValueProducer keySchemaAndValueProducer, SchemaAndValueProducer valueSchemaAndValueProducer, Map<String, String> sourceOffset, String topicName, BsonDocument keyDocument, BsonDocument valueDocument) {
        try {
            SchemaAndValue keySchemaAndValue = keySchemaAndValueProducer.get(keyDocument);
            SchemaAndValue valueSchemaAndValue = valueSchemaAndValueProducer.get(valueDocument);
            return Optional.of(new SourceRecord(partition, sourceOffset, topicName, keySchemaAndValue.schema(), keySchemaAndValue.value(), valueSchemaAndValue.schema(), valueSchemaAndValue.value()));
        }
        catch (Exception e) {
            Supplier<String> errorMessage = () -> String.format("Exception creating Source record for: Key=%s Value=%s", keyDocument.toJson(), valueDocument.toJson());
            if (this.sourceConfig.logErrors()) {
                LOGGER.error(errorMessage.get(), (Throwable)e);
            }
            if (this.sourceConfig.tolerateErrors()) {
                if (this.sourceConfig.getDlqTopic().isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new SourceRecord(partition, sourceOffset, this.sourceConfig.getDlqTopic(), Schema.STRING_SCHEMA, keyDocument.toJson(), Schema.STRING_SCHEMA, valueDocument.toJson()));
            }
            throw new DataException(errorMessage.get(), e);
        }
    }

    @Override
    public synchronized void stop() {
        LOGGER.info("Stopping MongoDB source task");
        this.isRunning.set(false);
        this.isCopying.set(false);
        try (MongoClient ignored3 = this.mongoClient;
             MongoChangeStreamCursor<? extends BsonDocument> ignored2 = this.cursor;){
            MongoCopyDataManager ignored1 = this.copyDataManager;
            if (ignored1 != null) {
                ignored1.close();
            }
        }
        this.copyDataManager = null;
        this.heartbeatManager = null;
        this.cursor = null;
        this.mongoClient = null;
        this.supportsStartAfter = true;
        this.invalidatedCursor = false;
    }

    void initializeCursorAndHeartbeatManager(Time time, MongoSourceConfig sourceConfig, MongoClient mongoClient) {
        this.cursor = this.createCursor(sourceConfig, mongoClient);
        this.heartbeatManager = new HeartbeatManager(time, this.cursor, sourceConfig.getLong("heartbeat.interval.ms"), sourceConfig.getString("heartbeat.topic.name"), this.partitionMap);
    }

    MongoChangeStreamCursor<? extends BsonDocument> createCursor(MongoSourceConfig sourceConfig, MongoClient mongoClient) {
        LOGGER.debug("Creating a MongoCursor");
        return this.tryCreateCursor(sourceConfig, mongoClient, this.getResumeToken(sourceConfig));
    }

    private MongoChangeStreamCursor<? extends BsonDocument> tryRecreateCursor(MongoException e) {
        int errorCode = e instanceof MongoCommandException ? ((MongoCommandException)e).getErrorCode() : e.getCode();
        String errorMessage = e instanceof MongoCommandException ? ((MongoCommandException)e).getErrorMessage() : e.getMessage();
        LOGGER.warn("Failed to resume change stream: {} {}\n===================================================================================\nWhen the resume token is no longer available there is the potential for data loss.\n\nRestarting the change stream with no resume token because `errors.tolerance=all`.\n===================================================================================\n", (Object)errorMessage, (Object)errorCode);
        this.invalidatedCursor = true;
        return this.tryCreateCursor(this.sourceConfig, this.mongoClient, null);
    }

    private MongoChangeStreamCursor<? extends BsonDocument> tryCreateCursor(MongoSourceConfig sourceConfig, MongoClient mongoClient, BsonDocument resumeToken) {
        try {
            ChangeStreamIterable<Document> changeStreamIterable = this.getChangeStreamIterable(sourceConfig, mongoClient);
            if (resumeToken != null && this.supportsStartAfter) {
                LOGGER.info("Resuming the change stream after the previous offset: {}", (Object)resumeToken);
                changeStreamIterable.startAfter(resumeToken);
            } else if (resumeToken != null && !this.invalidatedCursor) {
                LOGGER.info("Resuming the change stream after the previous offset using resumeAfter: {}", (Object)resumeToken);
                changeStreamIterable.resumeAfter(resumeToken);
            } else {
                LOGGER.info("New change stream cursor created without offset.");
            }
            return (MongoChangeStreamCursor)changeStreamIterable.withDocumentClass(RawBsonDocument.class).cursor();
        }
        catch (MongoCommandException e) {
            if (resumeToken != null) {
                if (this.invalidatedResumeToken(e)) {
                    this.invalidatedCursor = true;
                    return this.tryCreateCursor(sourceConfig, mongoClient, null);
                }
                if (this.doesNotSupportsStartAfter(e)) {
                    this.supportsStartAfter = false;
                    return this.tryCreateCursor(sourceConfig, mongoClient, resumeToken);
                }
                if (sourceConfig.tolerateErrors() && this.changeStreamNotValid(e)) {
                    return this.tryRecreateCursor(e);
                }
            }
            if (e.getErrorCode() == 26) {
                LOGGER.info("Namespace not found cursor closed.");
            } else {
                if (e.getErrorCode() == 20) {
                    LOGGER.warn("Illegal $changeStream operation: {} {}\n\n=====================================================================================\n{}\n\nPlease Note: Not all aggregation pipeline operations are suitable for modifying the\nchange stream output. For more information, please see the official documentation:\n   https://docs.mongodb.com/manual/changeStreams/\n=====================================================================================\n", new Object[]{e.getErrorMessage(), e.getErrorCode(), e.getErrorMessage()});
                    throw new ConnectException("Illegal $changeStream operation", e);
                }
                LOGGER.warn("Failed to resume change stream: {} {}\n\n=====================================================================================\nIf the resume token is no longer available then there is the potential for data loss.\nSaved resume tokens are managed by Kafka and stored with the offset data.\n\nTo restart the change stream with no resume token either: \n  * Create a new partition name using the `offset.partition.name` configuration.\n  * Set `errors.tolerance=all` and ignore the erroring resume token. \n  * Manually remove the old offset from its configured storage.\n\nResetting the offset will allow for the connector to be resume from the latest resume\ntoken. Using `copy.existing=true` ensures that all data will be outputted by the\nconnector but it will duplicate existing data.\n=====================================================================================\n", (Object)e.getErrorMessage(), (Object)e.getErrorCode());
                if (this.changeStreamNotValid(e)) {
                    throw new ConnectException("ResumeToken not found. Cannot create a change stream cursor", e);
                }
            }
            return null;
        }
    }

    private boolean doesNotSupportsStartAfter(MongoCommandException e) {
        return (e.getErrorCode() == 9 || e.getErrorCode() == 40415) && e.getErrorMessage().contains("startAfter");
    }

    private boolean invalidatedResumeToken(MongoCommandException e) {
        return e.getErrorCode() == 260;
    }

    private boolean changeStreamNotValid(MongoException e) {
        if (INVALID_CHANGE_STREAM_ERRORS.contains(e.getCode())) {
            return true;
        }
        String errorMessage = e instanceof MongoCommandException ? ((MongoCommandException)e).getErrorMessage().toLowerCase(Locale.ROOT) : e.getMessage().toLowerCase(Locale.ROOT);
        return !(!errorMessage.contains(RESUME_TOKEN) && !errorMessage.contains(RESUME_POINT) || !errorMessage.contains(NOT_FOUND) && !errorMessage.contains(DOES_NOT_EXIST) && !errorMessage.contains(INVALID_RESUME_TOKEN) && !errorMessage.contains(NO_LONGER_IN_THE_OPLOG));
    }

    Map<String, Object> createPartitionMap(MongoSourceConfig sourceConfig) {
        if (this.partitionMap == null) {
            String partitionName = sourceConfig.getString("offset.partition.name");
            if (partitionName.isEmpty()) {
                partitionName = this.createDefaultPartitionName(sourceConfig);
            }
            this.partitionMap = Collections.singletonMap(NS_KEY, partitionName);
        }
        return this.partitionMap;
    }

    Map<String, Object> createLegacyPartitionMap(MongoSourceConfig sourceConfig) {
        return Collections.singletonMap(NS_KEY, this.createLegacyPartitionName(sourceConfig));
    }

    String createLegacyPartitionName(MongoSourceConfig sourceConfig) {
        return String.format("%s/%s.%s", sourceConfig.getString("connection.uri"), sourceConfig.getString("database"), sourceConfig.getString("collection"));
    }

    String createDefaultPartitionName(MongoSourceConfig sourceConfig) {
        ConnectionString connectionString = sourceConfig.getConnectionString();
        StringBuilder builder = new StringBuilder();
        builder.append(connectionString.isSrvProtocol() ? "mongodb+srv://" : "mongodb://");
        builder.append(String.join((CharSequence)",", connectionString.getHosts()));
        builder.append("/");
        builder.append(sourceConfig.getString("database"));
        if (!sourceConfig.getString("collection").isEmpty()) {
            builder.append(".");
            builder.append(sourceConfig.getString("collection"));
        }
        return builder.toString();
    }

    private boolean shouldCopyData() {
        Map<String, Object> offset = this.getOffset(this.sourceConfig);
        return this.sourceConfig.getBoolean("copy.existing") != false && (offset == null || offset.containsKey(COPY_KEY));
    }

    private void setCachedResultAndResumeToken() {
        MongoCursor changeStreamCursor;
        try {
            changeStreamCursor = this.getChangeStreamIterable(this.sourceConfig, this.mongoClient).cursor();
        }
        catch (MongoCommandException e) {
            if (e.getErrorCode() == 26) {
                return;
            }
            throw new ConnectException(e);
        }
        ChangeStreamDocument firstResult = (ChangeStreamDocument)changeStreamCursor.tryNext();
        if (firstResult != null) {
            this.cachedResult = new BsonDocumentWrapper<ChangeStreamDocument<Document>>(firstResult, ChangeStreamDocument.createCodec(Document.class, MongoClientSettings.getDefaultCodecRegistry()));
        }
        this.cachedResumeToken = firstResult != null ? firstResult.getResumeToken() : changeStreamCursor.getResumeToken();
        changeStreamCursor.close();
    }

    private Optional<BsonDocument> getNextDocument() {
        block12: {
            if (this.isCopying.get()) {
                Optional<BsonDocument> result = this.copyDataManager.poll();
                if (result.isPresent() || this.copyDataManager.isCopying()) {
                    return result;
                }
                LOGGER.info("Shutting down executors");
                this.isCopying.set(false);
                if (this.cachedResult != null) {
                    result = Optional.of(this.cachedResult);
                    this.cachedResult = null;
                    return result;
                }
                LOGGER.info("Finished copying existing data from the collection(s).");
            }
            if (this.cursor == null) {
                this.initializeCursorAndHeartbeatManager(this.time, this.sourceConfig, this.mongoClient);
            }
            if (this.cursor != null) {
                try {
                    BsonDocument next = (BsonDocument)this.cursor.tryNext();
                    if (next == null && this.cursor.getServerCursor() == null) {
                        this.invalidateCursorAndReinitialize();
                        next = this.cursor != null ? (BsonDocument)this.cursor.tryNext() : null;
                    }
                    return Optional.ofNullable(next);
                }
                catch (MongoException e) {
                    this.closeCursor();
                    if (this.isRunning.get()) {
                        if (this.sourceConfig.tolerateErrors() && this.changeStreamNotValid(e)) {
                            this.cursor = this.tryRecreateCursor(e);
                        } else {
                            LOGGER.info("An exception occurred when trying to get the next item from the Change Stream", (Throwable)e);
                        }
                    }
                    return Optional.empty();
                }
                catch (Exception e) {
                    this.closeCursor();
                    if (!this.isRunning.get()) break block12;
                    throw new ConnectException("Unexpected error: " + e.getMessage(), e);
                }
            }
        }
        return Optional.empty();
    }

    private void closeCursor() {
        if (this.cursor != null) {
            try {
                this.cursor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cursor = null;
        }
    }

    private void invalidateCursorAndReinitialize() {
        this.invalidatedCursor = true;
        this.cursor.close();
        this.cursor = null;
        this.initializeCursorAndHeartbeatManager(this.time, this.sourceConfig, this.mongoClient);
    }

    private ChangeStreamIterable<Document> getChangeStreamIterable(MongoSourceConfig sourceConfig, MongoClient mongoClient) {
        ChangeStreamIterable<Document> changeStream;
        String database = sourceConfig.getString("database");
        String collection = sourceConfig.getString("collection");
        Optional<List<Document>> pipeline = sourceConfig.getPipeline();
        if (database.isEmpty()) {
            LOGGER.info("Watching all changes on the cluster");
            changeStream = pipeline.map(mongoClient::watch).orElse(mongoClient.watch());
        } else if (collection.isEmpty()) {
            LOGGER.info("Watching for database changes on '{}'", (Object)database);
            MongoDatabase db = mongoClient.getDatabase(database);
            changeStream = pipeline.map(db::watch).orElse(db.watch());
        } else {
            LOGGER.info("Watching for collection changes on '{}.{}'", (Object)database, (Object)collection);
            MongoCollection<Document> coll = mongoClient.getDatabase(database).getCollection(collection);
            changeStream = pipeline.map(coll::watch).orElse(coll.watch());
        }
        int batchSize = sourceConfig.getInt("batch.size");
        if (batchSize > 0) {
            changeStream.batchSize(batchSize);
        }
        sourceConfig.getFullDocument().ifPresent(changeStream::fullDocument);
        sourceConfig.getCollation().ifPresent(changeStream::collation);
        return changeStream;
    }

    Map<String, Object> getOffset(MongoSourceConfig sourceConfig) {
        if (this.context != null) {
            Map<String, Object> offset = this.context.offsetStorageReader().offset(this.createPartitionMap(sourceConfig));
            if (offset == null && sourceConfig.getString("offset.partition.name").isEmpty()) {
                offset = this.context.offsetStorageReader().offset(this.createLegacyPartitionMap(sourceConfig));
            }
            return offset;
        }
        return null;
    }

    BsonDocument getResumeToken(MongoSourceConfig sourceConfig) {
        BsonDocument resumeToken = null;
        if (this.cachedResumeToken != null) {
            resumeToken = this.cachedResumeToken;
            this.cachedResumeToken = null;
        } else if (this.invalidatedCursor) {
            this.invalidatedCursor = false;
        } else {
            Map<String, Object> offset = this.getOffset(sourceConfig);
            if (offset != null && offset.containsKey(ID_FIELD) && !offset.containsKey(COPY_KEY)) {
                resumeToken = BsonDocument.parse((String)offset.get(ID_FIELD));
                if (offset.containsKey("HEARTBEAT")) {
                    LOGGER.info("Resume token from heartbeat: {}", (Object)resumeToken);
                }
            }
        }
        return resumeToken;
    }
}

