/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.namespace.mapping;

import com.mongodb.MongoNamespace;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.namespace.mapping.NamespaceMapper;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;

public class DefaultNamespaceMapper
implements NamespaceMapper {
    private MongoNamespace namespace;

    @Override
    public void configure(MongoSinkTopicConfig config) {
        String databaseName = config.getString("database");
        String collectionName = config.getString("collection");
        if (collectionName.isEmpty()) {
            collectionName = config.getTopic();
        }
        this.namespace = new MongoNamespace(databaseName, collectionName);
    }

    @Override
    public MongoNamespace getNamespace(SinkRecord sinkRecord, SinkDocument sinkDocument) {
        return this.namespace;
    }
}

