/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter;

import com.mongodb.kafka.connect.sink.converter.ByteArrayRecordConverter;
import com.mongodb.kafka.connect.sink.converter.LazyBsonDocument;
import com.mongodb.kafka.connect.sink.converter.MapRecordConverter;
import com.mongodb.kafka.connect.sink.converter.RecordConverter;
import com.mongodb.kafka.connect.sink.converter.SchemaRecordConverter;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.converter.StringRecordConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkConverter.class);
    private static final RecordConverter SCHEMA_RECORD_CONVERTER = new SchemaRecordConverter();
    private static final RecordConverter MAP_RECORD_CONVERTER = new MapRecordConverter();
    private static final RecordConverter STRING_RECORD_CONVERTER = new StringRecordConverter();
    private static final RecordConverter BYTE_ARRAY_RECORD_CONVERTER = new ByteArrayRecordConverter();

    public SinkDocument convert(SinkRecord record) {
        LOGGER.debug(record.toString());
        LazyBsonDocument keyDoc = null;
        if (record.key() != null) {
            keyDoc = new LazyBsonDocument(record, LazyBsonDocument.Type.KEY, (schema, data) -> this.getRecordConverter((Schema)schema, data).convert((Schema)schema, data));
        }
        LazyBsonDocument valueDoc = null;
        if (record.value() != null) {
            valueDoc = new LazyBsonDocument(record, LazyBsonDocument.Type.VALUE, (schema, data) -> this.getRecordConverter((Schema)schema, data).convert((Schema)schema, data));
        }
        return new SinkDocument(keyDoc, valueDoc);
    }

    private RecordConverter getRecordConverter(Schema schema, Object data) {
        if (schema != null && data instanceof Struct) {
            LOGGER.debug("using schemaful converter");
            return SCHEMA_RECORD_CONVERTER;
        }
        if (data instanceof Map) {
            LOGGER.debug("using schemaless converter");
            return MAP_RECORD_CONVERTER;
        }
        if (data instanceof String) {
            LOGGER.debug("using raw converter");
            return STRING_RECORD_CONVERTER;
        }
        if (data instanceof byte[]) {
            LOGGER.debug("using bson converter");
            return BYTE_ARRAY_RECORD_CONVERTER;
        }
        throw new DataException("No converter present due to unexpected object type: " + data.getClass().getName());
    }
}

